/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.osgi.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class OSGiFileLocator {
    public static final String JRUBY_SYMBOLIC_NAME = "org.jruby.jruby";
    private static Method BUNDLE_URL_CONNECTION_getLocalURL = null;
    private static Method BUNDLE_URL_CONNECTION_getFileURL = null;

    public static File getJRubyHomeFolder() throws IOException {
        return OSGiFileLocator.getFileInBundle(JRUBY_SYMBOLIC_NAME, "/META-INF/jruby.home");
    }

    public static File getFileInBundle(String symbolicName, String path2) throws IOException {
        Bundle bundle = OSGiFileLocator.getBundle(symbolicName);
        if (bundle == null) {
            throw new IOException("Unable to find the bundle " + symbolicName);
        }
        return OSGiFileLocator.getFileInBundle(bundle, path2);
    }

    public static File getFileInBundle(Bundle bundle, String path2) throws IOException {
        URL url = null;
        try {
            url = OSGiFileLocator.getFileURL(bundle.getEntry(path2));
            return new File(url.toURI());
        }
        catch (NullPointerException ne) {
            throw new IOException("Unable to find the " + path2 + " folder in the bundle '" + bundle.getSymbolicName() + "'; is the org.jruby.jruby bundle unzipped? ");
        }
        catch (Exception e) {
            IOException exception2 = new IOException("Unable to find the " + path2 + " folder in the bundle '" + bundle.getSymbolicName() + "'");
            exception2.initCause(e);
            throw exception2;
        }
    }

    public static Bundle getBundle(String symbolicName) {
        BundleContext bc = FrameworkUtil.getBundle(OSGiFileLocator.class).getBundleContext();
        if (bc == null) {
            try {
                FrameworkUtil.getBundle(OSGiFileLocator.class).start();
            }
            catch (BundleException e) {
                throw new IllegalStateException("Could not start the bundle " + FrameworkUtil.getBundle(OSGiFileLocator.class).getSymbolicName());
            }
            bc = FrameworkUtil.getBundle(OSGiFileLocator.class).getBundleContext();
            if (bc == null) {
                throw new IllegalStateException("The bundle " + FrameworkUtil.getBundle(OSGiFileLocator.class).getSymbolicName() + " is not activated.");
            }
        }
        for (Bundle b : FrameworkUtil.getBundle(OSGiFileLocator.class).getBundleContext().getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        return null;
    }

    public static URL getLocalURL(URL url) {
        if ("bundleresource".equals(url.getProtocol()) || "bundleentry".equals(url.getProtocol())) {
            try {
                URLConnection conn = url.openConnection();
                if (BUNDLE_URL_CONNECTION_getLocalURL == null && conn.getClass().getName().equals("org.eclipse.osgi.framework.internal.core.BundleURLConnection")) {
                    BUNDLE_URL_CONNECTION_getLocalURL = conn.getClass().getMethod("getLocalURL", new Class[0]);
                    BUNDLE_URL_CONNECTION_getLocalURL.setAccessible(true);
                }
                if (BUNDLE_URL_CONNECTION_getLocalURL != null) {
                    return (URL)BUNDLE_URL_CONNECTION_getLocalURL.invoke((Object)conn, new Object[0]);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return url;
    }

    public static URL getFileURL(URL url) {
        if ("bundleresource".equals(url.getProtocol()) || "bundleentry".equals(url.getProtocol())) {
            try {
                URLConnection conn = url.openConnection();
                if (BUNDLE_URL_CONNECTION_getFileURL == null && conn.getClass().getName().equals("org.eclipse.osgi.framework.internal.core.BundleURLConnection")) {
                    BUNDLE_URL_CONNECTION_getFileURL = conn.getClass().getMethod("getFileURL", new Class[0]);
                    BUNDLE_URL_CONNECTION_getFileURL.setAccessible(true);
                }
                if (BUNDLE_URL_CONNECTION_getFileURL != null) {
                    return (URL)BUNDLE_URL_CONNECTION_getFileURL.invoke((Object)conn, new Object[0]);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return url;
    }
}

