/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IReceiver;
import com.sun.star.lib.uno.environments.remote.Message;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.uno.Any;
import com.sun.star.uno.IMethodDescription;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XCurrentContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class Job {
    protected Job _next;
    protected IReceiver _iReceiver;
    protected Message _iMessage;
    Object _disposeId;
    protected Object _object;

    public Job(Object object, IReceiver iReceiver, Message message) {
        this._object = object;
        this._iReceiver = iReceiver;
        this._iMessage = message;
    }

    protected Object dispatch_queryInterface(Type type) {
        Class clazz = type.getTypeDescription().getZClass();
        Any any = null;
        Object object = UnoRuntime.queryInterface(clazz, this._object);
        if (object != null) {
            any = new Any(type, object);
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Throwable {
        Object object = this._iMessage.getResult();
        if (this._iMessage.isRequest()) {
            Object object2 = null;
            Throwable throwable = null;
            IMethodDescription iMethodDescription = this._iMessage.getMethod();
            Object[] objectArray = this._iMessage.getArguments();
            XCurrentContext xCurrentContext = UnoRuntime.getCurrentContext();
            UnoRuntime.setCurrentContext(this._iMessage.getCurrentContext());
            try {
                object2 = iMethodDescription.getIndex() == 0 ? this.dispatch_queryInterface((Type)objectArray[0]) : iMethodDescription.getMethod().invoke(this._object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                if (throwable == null) {
                    throwable = invocationTargetException;
                }
            }
            catch (Exception exception) {
                throwable = exception;
            }
            finally {
                UnoRuntime.setCurrentContext(xCurrentContext);
            }
            if (this._iMessage.isSynchronous()) {
                if (throwable == null) {
                    this._iReceiver.sendReply(false, this._iMessage.getThreadId(), object2);
                } else {
                    if (throwable != null && !(throwable instanceof com.sun.star.uno.Exception) && !(throwable instanceof RuntimeException)) {
                        StringWriter stringWriter = new StringWriter();
                        throwable.printStackTrace(new PrintWriter(stringWriter));
                        throwable = new RuntimeException("Java exception: <" + stringWriter + ">", (Object)null);
                    }
                    this._iReceiver.sendReply(true, this._iMessage.getThreadId(), throwable);
                }
            }
            return null;
        }
        if (this._iMessage.isAbnormalTermination()) {
            throw this.remoteUnoRequestRaisedException(this._iMessage.getResult());
        }
        return this._iMessage.getResult();
    }

    public ThreadId getThreadId() {
        return this._iMessage.getThreadId();
    }

    public boolean isRequest() {
        return this._iMessage.isRequest();
    }

    public boolean isSynchronous() {
        return this._iMessage.isSynchronous();
    }

    public void dispose() {
    }

    private Exception remoteUnoRequestRaisedException(Object object) {
        Exception exception = (Exception)object;
        exception.fillInStackTrace();
        return exception;
    }
}

