/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.security.AccessManager;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.WorkspaceImpl;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.DefinitionProvider;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.oak.spi.xml.Importer;
import org.apache.jackrabbit.oak.spi.xml.NodeInfo;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImporterImpl
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(ImporterImpl.class);
    private final Tree importTargetTree;
    private final Tree ntTypesRoot;
    private final int uuidBehavior;
    private final String userID;
    private final AccessManager accessManager;
    private final IdentifierManager currentStateIdManager;
    private final IdentifierManager baseStateIdManager;
    private final EffectiveNodeTypeProvider effectiveNodeTypeProvider;
    private final DefinitionProvider definitionProvider;
    private final Set<String> uuids = new HashSet<String>();
    private final Stack<Tree> parents;
    private final ReferenceChangeTracker refTracker;
    private final List<ProtectedItemImporter> pItemImporters = new ArrayList<ProtectedItemImporter>();
    private ProtectedNodeImporter pnImporter;

    public ImporterImpl(String absPath, SessionContext sessionContext, Root root, int uuidBehavior, boolean isWorkspaceImport) throws RepositoryException {
        if (!PathUtils.isAbsolute((String)absPath)) {
            throw new RepositoryException("Not an absolute path: " + absPath);
        }
        String oakPath = sessionContext.getOakPathKeepIndex(absPath);
        if (oakPath == null) {
            throw new RepositoryException("Invalid name or path: " + absPath);
        }
        SessionDelegate sd = sessionContext.getSessionDelegate();
        if (isWorkspaceImport && sd.hasPendingChanges()) {
            throw new RepositoryException("Pending changes on session. Cannot run workspace import.");
        }
        this.uuidBehavior = uuidBehavior;
        this.userID = sd.getAuthInfo().getUserID();
        this.importTargetTree = root.getTree(absPath);
        if (!this.importTargetTree.exists()) {
            throw new PathNotFoundException(absPath);
        }
        WorkspaceImpl wsp = sessionContext.getWorkspace();
        VersionManager vMgr = wsp.getVersionManager();
        if (!vMgr.isCheckedOut(absPath)) {
            throw new VersionException("Target node is checked in.");
        }
        if (this.importTargetTree.getStatus() != Tree.Status.NEW && wsp.getLockManager().isLocked(absPath)) {
            throw new LockException("Target node is locked.");
        }
        this.effectiveNodeTypeProvider = wsp.getNodeTypeManager();
        this.definitionProvider = wsp.getNodeTypeManager();
        this.ntTypesRoot = root.getTree("/jcr:system/jcr:nodeTypes");
        this.accessManager = sessionContext.getAccessManager();
        this.currentStateIdManager = new IdentifierManager(root);
        this.baseStateIdManager = new IdentifierManager(sd.getContentSession().getLatestRoot());
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(this.importTargetTree);
        this.pItemImporters.clear();
        for (ProtectedItemImporter importer : sessionContext.getProtectedItemImporters()) {
            if (!importer.init((Session)sessionContext.getSession(), root, (NamePathMapper)sessionContext, isWorkspaceImport, uuidBehavior, this.refTracker, sessionContext.getSecurityProvider())) continue;
            this.pItemImporters.add(importer);
        }
    }

    private Tree createTree(@Nonnull Tree parent, @Nonnull NodeInfo nInfo, @CheckForNull String uuid) throws RepositoryException {
        String ntName = nInfo.getPrimaryTypeName();
        Tree child = TreeUtil.addChild((Tree)parent, (String)nInfo.getName(), (String)ntName, (Tree)this.ntTypesRoot, (String)this.userID);
        if (ntName != null) {
            this.accessManager.checkPermissions(child, child.getProperty("jcr:primaryType"), 512L);
        }
        if (uuid != null) {
            child.setProperty("jcr:uuid", (Object)uuid);
        }
        for (String mixin : nInfo.getMixinTypeNames()) {
            TreeUtil.addMixin((Tree)child, (String)mixin, (Tree)this.ntTypesRoot, (String)this.userID);
        }
        return child;
    }

    private void createProperty(Tree tree, PropInfo pInfo, PropertyDefinition def) throws RepositoryException {
        List values = pInfo.getValues(pInfo.getTargetType(def));
        String name = pInfo.getName();
        int type = pInfo.getType();
        PropertyState propertyState = values.size() == 1 && !def.isMultiple() ? PropertyStates.createProperty((String)name, (Value)((Value)values.get(0))) : PropertyStates.createProperty((String)name, (Iterable)values);
        tree.setProperty(propertyState);
        if (type == 9 || type == 10) {
            this.refTracker.processedReference((Object)new Reference(tree, name));
        }
    }

    private Tree resolveUUIDConflict(Tree parent, Tree conflicting, String conflictingId, NodeInfo nodeInfo) throws RepositoryException {
        Tree tree;
        if (this.uuidBehavior == 0) {
            tree = this.createTree(parent, nodeInfo, UUID.randomUUID().toString());
            if (this.isNodeType(tree, "mix:referenceable")) {
                this.refTracker.put(nodeInfo.getUUID(), TreeUtil.getString((Tree)tree, (String)"jcr:uuid"));
            }
        } else {
            if (this.uuidBehavior == 3) {
                String msg = "a node with uuid " + nodeInfo.getUUID() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                if (conflicting == null) {
                    String msg = "node with uuid " + conflictingId + " cannot be removed";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                if (this.importTargetTree.getPath().startsWith(conflicting.getPath())) {
                    String msg = "cannot remove ancestor node";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                conflicting.remove();
                tree = this.createTree(parent, nodeInfo, nodeInfo.getUUID());
            } else if (this.uuidBehavior == 2) {
                if (conflicting == null) {
                    String msg = "node with uuid " + conflictingId + " cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                if (conflicting.isRoot()) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                parent = conflicting.getParent();
                conflicting.remove();
                tree = this.createTree(parent, nodeInfo, nodeInfo.getUUID());
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return tree;
    }

    public void start() throws RepositoryException {
    }

    public void startNode(NodeInfo nodeInfo, List<PropInfo> propInfos) throws RepositoryException {
        Tree existing;
        NodeDefinition def;
        Tree parent = this.parents.peek();
        Tree tree = null;
        String id = nodeInfo.getUUID();
        String nodeName = nodeInfo.getName();
        String ntName = nodeInfo.getPrimaryTypeName();
        if (parent == null) {
            log.debug("Skipping node: " + nodeName);
            this.parents.push(null);
            if (this.pnImporter != null) {
                this.pnImporter.startChildInfo(nodeInfo, propInfos);
            }
            return;
        }
        NodeDefinition parentDef = this.getDefinition(parent);
        if (parentDef.isProtected()) {
            this.parents.push(null);
            log.debug("Skipping protected node: " + nodeName);
            if (this.pnImporter != null) {
                this.pnImporter.startChildInfo(nodeInfo, propInfos);
            } else {
                for (ProtectedItemImporter pni : this.pItemImporters) {
                    if (!(pni instanceof ProtectedNodeImporter) || !((ProtectedNodeImporter)pni).start(parent)) continue;
                    log.debug("Protected node -> delegated to ProtectedNodeImporter");
                    this.pnImporter = (ProtectedNodeImporter)pni;
                    this.pnImporter.startChildInfo(nodeInfo, propInfos);
                    break;
                }
            }
            return;
        }
        if (parent.hasChild(nodeName) && !(def = this.getDefinition(existing = parent.getChild(nodeName))).allowsSameNameSiblings()) {
            if (def.isProtected() && this.isNodeType(existing, ntName)) {
                log.debug("Skipping protected node: " + existing);
                this.parents.push(existing);
                return;
            }
            if (def.isAutoCreated() && this.isNodeType(existing, ntName)) {
                tree = existing;
            } else {
                String existingIdentifier = IdentifierManager.getIdentifier((Tree)existing);
                if (!existingIdentifier.equals(id) || this.uuidBehavior != 1 && this.uuidBehavior != 2) {
                    throw new ItemExistsException("Node with the same UUID exists:" + existing);
                }
            }
        }
        if (tree == null) {
            if (id == null) {
                tree = this.createTree(parent, nodeInfo, id);
            } else {
                Tree conflicting = this.baseStateIdManager.getTree(id);
                if (conflicting == null) {
                    if (this.uuids.contains(id)) {
                        conflicting = this.currentStateIdManager.getTree(id);
                    }
                } else {
                    conflicting = this.currentStateIdManager.getTree(id);
                }
                if (conflicting != null && conflicting.exists() || this.uuidBehavior == 0) {
                    tree = this.resolveUUIDConflict(parent, conflicting, id, nodeInfo);
                    if (tree == null) {
                        this.parents.push(null);
                        log.debug("Skipping existing node " + nodeInfo.getName());
                        return;
                    }
                } else {
                    tree = this.createTree(parent, nodeInfo, id);
                }
            }
        }
        block1: for (PropInfo pi : propInfos) {
            PropertyDefinition def2 = pi.getPropertyDef(this.effectiveNodeTypeProvider.getEffectiveNodeType(tree));
            if (def2.isProtected()) {
                log.debug("Skipping protected property " + pi.getName());
                for (ProtectedItemImporter ppi : this.pItemImporters) {
                    if (!(ppi instanceof ProtectedPropertyImporter) || !((ProtectedPropertyImporter)ppi).handlePropInfo(tree, pi, def2)) continue;
                    log.debug("Protected property -> delegated to ProtectedPropertyImporter");
                    continue block1;
                }
                continue;
            }
            this.createProperty(tree, pi, def2);
        }
        this.parents.push(tree);
    }

    public void endNode(NodeInfo nodeInfo) throws RepositoryException {
        Tree parent = this.parents.pop();
        if (parent == null) {
            if (this.pnImporter != null) {
                this.pnImporter.endChildInfo();
            }
        } else if (this.getDefinition(parent).isProtected() && this.pnImporter != null) {
            this.pnImporter.end(parent);
            this.pnImporter = null;
        }
        this.collectUUIDs(parent);
    }

    private void collectUUIDs(Tree tree) {
        if (tree == null) {
            return;
        }
        String uuid = TreeUtil.getString((Tree)tree, (String)"jcr:uuid");
        if (uuid != null) {
            this.uuids.add(uuid);
        }
        for (Tree child : tree.getChildren()) {
            this.collectUUIDs(child);
        }
    }

    public void end() throws RepositoryException {
        for (ProtectedItemImporter ppi : this.pItemImporters) {
            ppi.processReferences();
        }
        Iterator iter = this.refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            Object ref = iter.next();
            if (!(ref instanceof Reference)) continue;
            Reference reference = (Reference)ref;
            if (reference.isMultiple()) {
                Iterable values = (Iterable)reference.property.getValue(Type.STRINGS);
                ArrayList newValues = Lists.newArrayList();
                for (String original : values) {
                    String adjusted = this.refTracker.get(original);
                    if (adjusted != null) {
                        newValues.add(adjusted);
                        continue;
                    }
                    newValues.add(original);
                }
                reference.setProperty(newValues);
                continue;
            }
            String original = (String)reference.property.getValue(Type.STRING);
            String adjusted = this.refTracker.get(original);
            if (adjusted == null) continue;
            reference.setProperty(adjusted);
        }
        this.refTracker.clear();
    }

    private boolean isNodeType(Tree tree, String ntName) throws RepositoryException {
        return this.effectiveNodeTypeProvider.isNodeType(tree, ntName);
    }

    private NodeDefinition getDefinition(Tree tree) throws RepositoryException {
        if (tree.isRoot()) {
            return this.definitionProvider.getRootDefinition();
        }
        return this.definitionProvider.getDefinition(tree.getParent(), tree);
    }

    private static final class Reference {
        private final Tree tree;
        private final PropertyState property;

        private Reference(Tree tree, String propertyName) {
            this.tree = tree;
            this.property = tree.getProperty(propertyName);
        }

        private boolean isMultiple() {
            return this.property.isArray();
        }

        private void setProperty(String newValue) {
            PropertyState prop = PropertyStates.createProperty((String)this.property.getName(), (String)newValue, (int)this.property.getType().tag());
            this.tree.setProperty(prop);
        }

        private void setProperty(Iterable<String> newValues) {
            PropertyState prop = PropertyStates.createProperty((String)this.property.getName(), newValues, (Type)this.property.getType());
            this.tree.setProperty(prop);
        }
    }
}

