/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermNumberList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class TermFloatList
extends TermNumberList<Float> {
    private float[] _elements = null;
    public static final float VALUE_MISSING = Float.MIN_VALUE;

    private static float parse(String s) {
        if (s == null || s.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(s);
    }

    public TermFloatList() {
    }

    public TermFloatList(String formatString) {
        super(formatString);
    }

    public TermFloatList(int capacity, String formatString) {
        super(capacity, formatString);
    }

    @Override
    public boolean add(String o) {
        return ((FloatArrayList)this._innerList).add(TermFloatList.parse(o));
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = Float.class;
        return capacity > 0 ? new FloatArrayList(capacity) : new FloatArrayList();
    }

    @Override
    public String get(int index) {
        DecimalFormat formatter = (DecimalFormat)this._formatter.get();
        if (formatter == null) {
            return String.valueOf(this._elements[index]);
        }
        return formatter.format(this._elements[index]);
    }

    public float getPrimitiveValue(int index) {
        if (index < this._elements.length) {
            return this._elements[index];
        }
        return Float.MIN_VALUE;
    }

    @Override
    public int indexOf(Object o) {
        float val = o instanceof String ? TermFloatList.parse((String)o) : ((Float)o).floatValue();
        float[] elements = ((FloatArrayList)this._innerList).elements();
        return Arrays.binarySearch(elements, val);
    }

    public int indexOf(float o) {
        return Arrays.binarySearch(this._elements, o);
    }

    @Override
    public void seal() {
        ((FloatArrayList)this._innerList).trim();
        this._elements = ((FloatArrayList)this._innerList).elements();
        int negativeIndexCheck = 1;
        if (this._elements.length > negativeIndexCheck && this._elements[negativeIndexCheck] < 0.0f) {
            int endPosition = this.indexOfWithType(0.0f);
            if (endPosition < 0) {
                endPosition = -1 * endPosition - 1;
            }
            for (int i = 0; i < (endPosition - negativeIndexCheck) / 2; ++i) {
                float tmp = this._elements[i + negativeIndexCheck];
                this._elements[i + negativeIndexCheck] = this._elements[endPosition - i - 1];
                this._elements[endPosition - i - 1] = tmp;
            }
        }
    }

    @Override
    protected Object parseString(String o) {
        return Float.valueOf(TermFloatList.parse(o));
    }

    public boolean contains(float val) {
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(Float val) {
        return Arrays.binarySearch(this._elements, val.floatValue()) >= 0;
    }

    @Override
    public boolean containsWithType(float val) {
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public int indexOfWithType(Float o) {
        return Arrays.binarySearch(this._elements, o.floatValue());
    }

    @Override
    public int indexOfWithType(float o) {
        return Arrays.binarySearch(this._elements, o);
    }

    @Override
    public double getDoubleValue(int index) {
        return this._elements[index];
    }
}

