/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import java.util.ArrayList;

public class BigIntBuffer {
    private static final int PAGESIZE = 1024;
    private static final int MASK = 1023;
    private static final int SHIFT = 10;
    private ArrayList<int[]> _buffer = new ArrayList();
    private int _allocSize = 0;
    private int _mark = 0;

    public int alloc(int size) {
        if (size > 1024) {
            throw new IllegalArgumentException("size too big");
        }
        if (this._mark + size > this._allocSize) {
            int[] page = new int[1024];
            this._buffer.add(page);
            this._allocSize += 1024;
        }
        int ptr = this._mark;
        this._mark += size;
        return ptr;
    }

    public void reset() {
        this._mark = 0;
    }

    public void set(int ptr, int val) {
        int[] page = this._buffer.get(ptr >> 10);
        page[ptr & 0x3FF] = val;
    }

    public int get(int ptr) {
        int[] page = this._buffer.get(ptr >> 10);
        return page[ptr & 0x3FF];
    }
}

