/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.util.SynchronizedInputStream;
import de.schlichtherle.util.zip.BasicZipFile;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.zip.ZipException;

public class ZipFile
extends BasicZipFile {
    public ZipFile(String name) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        super(name);
    }

    public ZipFile(String name, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(name, charset);
    }

    public ZipFile(String name, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(name, charset, preambled, postambled);
    }

    public ZipFile(File file) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        super(file);
    }

    public ZipFile(File file, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(file, charset);
    }

    public ZipFile(File file, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(file, charset, preambled, postambled);
    }

    public ZipFile(ReadOnlyFile rof) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        super(rof);
    }

    public ZipFile(ReadOnlyFile rof, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(rof, charset);
    }

    public ZipFile(ReadOnlyFile rof, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(rof, charset, preambled, postambled);
    }

    public synchronized Enumeration entries() {
        return new Enumeration(){
            Enumeration e;
            {
                this.e = ZipFile.super.entries();
            }

            public boolean hasMoreElements() {
                return this.e.hasMoreElements();
            }

            public Object nextElement() {
                return ((ZipEntry)this.e.nextElement()).clone();
            }
        };
    }

    public synchronized ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        return ze != null ? (ZipEntry)ze.clone() : null;
    }

    public synchronized InputStream getPreambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPreambleInputStream(), this);
    }

    public synchronized InputStream getPostambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPostambleInputStream(), this);
    }

    public synchronized boolean busy() {
        return super.busy();
    }

    protected synchronized InputStream getInputStream(String name, boolean check, boolean inflate) throws IOException {
        return new SynchronizedInputStream(super.getInputStream(name, check, inflate), this);
    }

    public synchronized void close() throws IOException {
        super.close();
    }
}

