/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IMetaData;

public class DisplayWebcamVideo {
    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("must pass in a driver name and a device name");
        }
        new DisplayWebcamVideo(args[0], args[1]);
    }

    public DisplayWebcamVideo(String driverName, String deviceName) {
        IContainer container = IContainer.make();
        IContainerFormat format = IContainerFormat.make();
        if (format.setInputFormat(driverName) < 0) {
            throw new IllegalArgumentException("couldn't open webcam device: " + driverName);
        }
        IMetaData params = IMetaData.make();
        params.setValue("framerate", "30/1");
        params.setValue("video_size", "320x240");
        int retval = container.open(deviceName, IContainer.Type.READ, format, false, true, params, null);
        if (retval < 0) {
            IError error = IError.make(retval);
            throw new IllegalArgumentException("could not open file: " + deviceName + "; Error: " + error.getDescription());
        }
        IMediaReader reader = ToolFactory.makeReader(container);
        reader.addListener(ToolFactory.makeViewer(true, 3));
        while (reader.readPacket() == null) {
        }
    }
}

