/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.RefCounted;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.XugglerJNI;
import java.util.concurrent.atomic.AtomicLong;

public class IPixelFormat
extends RefCounted {
    private volatile long swigCPtr;

    private void noop() {
        IBuffer.make(null, 1);
    }

    protected IPixelFormat(long cPtr, boolean cMemoryOwn) {
        super(XugglerJNI.SWIGIPixelFormatUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected IPixelFormat(long cPtr, boolean cMemoryOwn, AtomicLong ref) {
        super(XugglerJNI.SWIGIPixelFormatUpcast(cPtr), cMemoryOwn, ref);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IPixelFormat obj) {
        if (obj == null) {
            return 0L;
        }
        return obj.getMyCPtr();
    }

    @Override
    public long getMyCPtr() {
        if (this.swigCPtr == 0L) {
            throw new IllegalStateException("underlying native object already deleted");
        }
        return this.swigCPtr;
    }

    @Override
    public IPixelFormat copyReference() {
        if (this.swigCPtr == 0L) {
            return null;
        }
        return new IPixelFormat(this.swigCPtr, this.swigCMemOwn, this.getJavaRefCount());
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj instanceof IPixelFormat) {
            equal = ((IPixelFormat)obj).swigCPtr == this.swigCPtr;
        }
        return equal;
    }

    public int hashCode() {
        return (int)this.swigCPtr;
    }

    public static short getYUV420PPixel(IVideoPicture frame, int x, int y, YUVColorComponent c) {
        return XugglerJNI.IPixelFormat_getYUV420PPixel(IVideoPicture.getCPtr(frame), frame, x, y, c.swigValue());
    }

    public static void setYUV420PPixel(IVideoPicture frame, int x, int y, YUVColorComponent c, short value) {
        XugglerJNI.IPixelFormat_setYUV420PPixel(IVideoPicture.getCPtr(frame), frame, x, y, c.swigValue(), value);
    }

    public static int getYUV420PPixelOffset(IVideoPicture frame, int x, int y, YUVColorComponent c) {
        return XugglerJNI.IPixelFormat_getYUV420PPixelOffset(IVideoPicture.getCPtr(frame), frame, x, y, c.swigValue());
    }

    public static enum YUVColorComponent {
        YUV_Y(XugglerJNI.IPixelFormat_YUV_Y_get()),
        YUV_U(XugglerJNI.IPixelFormat_YUV_U_get()),
        YUV_V(XugglerJNI.IPixelFormat_YUV_V_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static YUVColorComponent swigToEnum(int swigValue) {
            YUVColorComponent[] swigValues = (YUVColorComponent[])YUVColorComponent.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (YUVColorComponent swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + YUVColorComponent.class + " with value " + swigValue);
        }

        private YUVColorComponent() {
            this.swigValue = SwigNext.next++;
        }

        private YUVColorComponent(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private YUVColorComponent(YUVColorComponent swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum Type {
        NONE(XugglerJNI.IPixelFormat_NONE_get()),
        YUV420P,
        YUYV422,
        RGB24,
        BGR24,
        YUV422P,
        YUV444P,
        YUV410P,
        YUV411P,
        GRAY8,
        MONOWHITE,
        MONOBLACK,
        PAL8,
        YUVJ420P,
        YUVJ422P,
        YUVJ444P,
        XVMC_MPEG2_MC,
        XVMC_MPEG2_IDCT,
        UYVY422,
        UYYVYY411,
        BGR8,
        BGR4,
        BGR4_BYTE,
        RGB8,
        RGB4,
        RGB4_BYTE,
        NV12,
        NV21,
        ARGB,
        RGBA,
        ABGR,
        BGRA,
        GRAY16BE,
        GRAY16LE,
        YUV440P,
        YUVJ440P,
        YUVA420P,
        VDPAU_H264,
        VDPAU_MPEG1,
        VDPAU_MPEG2,
        VDPAU_WMV3,
        VDPAU_VC1,
        RGB48BE,
        RGB48LE,
        RGB565BE,
        RGB565LE,
        RGB555BE,
        RGB555LE,
        BGR565BE,
        BGR565LE,
        BGR555BE,
        BGR555LE,
        VAAPI_MOCO,
        VAAPI_IDCT,
        VAAPI_VLD,
        YUV420P16LE,
        YUV420P16BE,
        YUV422P16LE,
        YUV422P16BE,
        YUV444P16LE,
        YUV444P16BE,
        VDPAU_MPEG4,
        DXVA2_VLD,
        RGB444LE,
        RGB444BE,
        BGR444LE,
        BGR444BE,
        GRAY8A,
        BGR48BE,
        BGR48LE,
        YUV420P9BE,
        YUV420P9LE,
        YUV420P10BE,
        YUV420P10LE,
        YUV422P10BE,
        YUV422P10LE,
        YUV444P9BE,
        YUV444P9LE,
        YUV444P10BE,
        YUV444P10LE,
        YUV422P9BE,
        YUV422P9LE,
        VDA_VLD,
        GBRP,
        GBRP9BE,
        GBRP9LE,
        GBRP10BE,
        GBRP10LE,
        GBRP16BE,
        GBRP16LE,
        RGBA64BE(XugglerJNI.IPixelFormat_RGBA64BE_get()),
        RGBA64LE,
        BGRA64BE,
        BGRA64LE,
        ZRGB(XugglerJNI.IPixelFormat_ZRGB_get()),
        RGB0,
        ZBGR,
        BGR0,
        YUVA444P,
        NB;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Type swigToEnum(int swigValue) {
            Type[] swigValues = (Type[])Type.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Type swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Type.class + " with value " + swigValue);
        }

        private Type() {
            this.swigValue = SwigNext.next++;
        }

        private Type(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Type(Type swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

