/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.ArrayList;
import java.util.List;
import jodd.util.InExRuleMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InExRules<T, R>
implements InExRuleMatcher<T, R> {
    protected List<Rule<R>> rules;
    protected final InExRuleMatcher<T, R> inExRuleMatcher;
    protected int includesCount;
    protected int excludesCount;
    protected boolean blacklist = true;

    public InExRules() {
        this.inExRuleMatcher = this;
    }

    public InExRules(InExRuleMatcher<T, R> inExRuleMatcher) {
        this.inExRuleMatcher = inExRuleMatcher;
    }

    public int totalRules() {
        if (this.rules == null) {
            return 0;
        }
        return this.rules.size();
    }

    public int totalIncludeRules() {
        return this.includesCount;
    }

    public int totalExcludeRules() {
        return this.excludesCount;
    }

    public boolean hasRules() {
        if (this.rules == null) {
            return false;
        }
        return this.rules.size() > 0;
    }

    public R getRule(int index) {
        return this.rules.get((int)index).value;
    }

    public void reset() {
        if (this.rules != null) {
            this.rules.clear();
        }
        this.excludesCount = 0;
        this.includesCount = 0;
        this.blacklist = true;
    }

    public void blacklist() {
        this.blacklist = true;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public void whitelist() {
        this.blacklist = false;
    }

    public boolean isWhitelist() {
        return !this.blacklist;
    }

    public void smartMode() {
        if (this.excludesCount == 0 && this.includesCount > 0) {
            this.whitelist();
        } else if (this.excludesCount > 0 && this.includesCount == 0) {
            this.blacklist();
        }
    }

    public void include(R rule) {
        this.addRule(rule, true);
    }

    public void exclude(R rule) {
        this.addRule(rule, false);
    }

    protected void addRule(R rule, boolean include) {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule<R>>();
        }
        if (include) {
            ++this.includesCount;
        } else {
            ++this.excludesCount;
        }
        Rule<R> newRule = new Rule<R>(rule, include);
        if (this.rules.contains(newRule)) {
            return;
        }
        this.rules.add(newRule);
    }

    public boolean match(T value) {
        return this.match(value, this.blacklist);
    }

    public boolean match(T value, boolean blacklist) {
        if (this.rules == null) {
            return blacklist;
        }
        boolean include = blacklist;
        if (include) {
            include = this.processExcludes(value, true);
            include = this.processIncludes(value, include);
        } else {
            include = this.processIncludes(value, false);
            include = this.processExcludes(value, include);
        }
        return include;
    }

    public boolean apply(T value, boolean flag) {
        return this.apply(value, this.blacklist, flag);
    }

    public boolean apply(T value, boolean blacklist, boolean flag) {
        if (this.rules == null) {
            return flag;
        }
        if (blacklist) {
            flag = this.processExcludes(value, flag);
            flag = this.processIncludes(value, flag);
        } else {
            flag = this.processIncludes(value, flag);
            flag = this.processExcludes(value, flag);
        }
        return flag;
    }

    protected boolean processIncludes(T value, boolean include) {
        if (this.includesCount > 0 && !include) {
            for (Rule<R> rule : this.rules) {
                if (!rule.include || !this.inExRuleMatcher.accept(value, rule.value, true)) continue;
                include = true;
                break;
            }
        }
        return include;
    }

    protected boolean processExcludes(T value, boolean include) {
        if (this.excludesCount > 0 && include) {
            for (Rule<R> rule : this.rules) {
                if (rule.include || !this.inExRuleMatcher.accept(value, rule.value, false)) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    @Override
    public boolean accept(T value, R rule, boolean include) {
        return value.equals(rule);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Rule<R> {
        public final R value;
        public final boolean include;

        public Rule(R value, boolean include) {
            this.value = value;
            this.include = include;
        }

        public String toString() {
            return (this.include ? "+" : "-") + this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            if (this.include != rule.include) {
                return false;
            }
            return this.value.equals(rule.value);
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.include ? 1 : 0);
            return result;
        }
    }
}

