/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.AltImpl;
import com.hp.hpl.mesa.rdf.jena.common.BagImpl;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.ModelI;
import com.hp.hpl.mesa.rdf.jena.common.ResourceI;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.common.SeqImpl;
import com.hp.hpl.mesa.rdf.jena.model.Alt;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Bag;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.ObjectF;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.ResourceF;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;

public class StatementImpl
extends ResourceImpl
implements Statement {
    protected Resource subject;
    protected Property predicate;
    protected RDFNode object;

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode) {
        this.subject = resource;
        this.predicate = property;
        this.object = rDFNode;
    }

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode, Model model) throws RDFException {
        super(model);
        this.subject = ((ModelI)((Object)model)).convert(resource);
        this.predicate = ((ModelI)((Object)model)).convert(property);
        this.object = ((ModelI)((Object)model)).convert(rDFNode);
    }

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode, AnonId anonId, Model model) throws RDFException {
        super(anonId, model);
        this.subject = ((ModelI)((Object)model)).convert(resource);
        this.predicate = ((ModelI)((Object)model)).convert(property);
        this.object = ((ModelI)((Object)model)).convert(rDFNode);
    }

    public StatementImpl(Resource resource, Property property, RDFNode rDFNode, String string, Model model) throws RDFException {
        super(string, model);
        this.subject = ((ModelI)((Object)model)).convert(resource);
        this.predicate = ((ModelI)((Object)model)).convert(property);
        this.object = ((ModelI)((Object)model)).convert(rDFNode);
    }

    public int hashCode() {
        return this.subject.hashCode() ^ this.predicate.hashCode() ^ this.object.hashCode();
    }

    public Resource getSubject() {
        return this.subject;
    }

    public Property getPredicate() {
        return this.predicate;
    }

    public RDFNode getObject() {
        return this.object;
    }

    public Statement getProperty(Property property) throws RDFException {
        if (this.object instanceof Resource) {
            return ((Resource)this.object).getProperty(property);
        }
        throw new RDFException(4);
    }

    public Statement getStatementProperty(Property property) throws RDFException {
        return super.getProperty(property);
    }

    public Resource getResource() throws RDFException {
        if (this.object instanceof Resource) {
            return (Resource)this.object;
        }
        throw new RDFException(4);
    }

    public Literal getLiteral() throws RDFException {
        if (this.object instanceof Literal) {
            return (Literal)this.object;
        }
        throw new RDFException(5);
    }

    public boolean getBoolean() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getBoolean();
        }
        throw new RDFException(5);
    }

    public byte getByte() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getByte();
        }
        throw new RDFException(5);
    }

    public short getShort() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getShort();
        }
        throw new RDFException(5);
    }

    public int getInt() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getInt();
        }
        throw new RDFException(5);
    }

    public long getLong() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getLong();
        }
        throw new RDFException(5);
    }

    public char getChar() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getChar();
        }
        throw new RDFException(5);
    }

    public float getFloat() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getFloat();
        }
        throw new RDFException(5);
    }

    public double getDouble() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getDouble();
        }
        throw new RDFException(5);
    }

    public String getString() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).toString();
        }
        throw new RDFException(5);
    }

    public Resource getResource(ResourceF resourceF) throws RDFException {
        if (this.object instanceof Resource) {
            try {
                return resourceF.createResource(((ResourceI)((Object)this.object)).getEmbeddedResource());
            }
            catch (Exception exception) {
                throw new RDFException(exception);
            }
        }
        throw new RDFException(4);
    }

    public Object getObject(ObjectF objectF) throws RDFException {
        try {
            return objectF.createObject(((Literal)this.object).toString());
        }
        catch (Exception exception) {
            throw new RDFException(exception);
        }
    }

    public Bag getBag() throws RDFException {
        if (this.object instanceof Bag) {
            return (Bag)this.object;
        }
        if (this.object instanceof Resource && this.model.contains((Resource)this.object, RDF.type, RDF.Bag)) {
            return new BagImpl((Resource)this.object, this.model);
        }
        throw new RDFException(15);
    }

    public Alt getAlt() throws RDFException {
        if (this.object instanceof Alt) {
            return (Alt)this.object;
        }
        if (this.object instanceof Resource && this.model.contains((Resource)this.object, RDF.type, RDF.Alt)) {
            return new AltImpl((Resource)this.object, this.model);
        }
        throw new RDFException(15);
    }

    public Seq getSeq() throws RDFException {
        if (this.object instanceof Seq) {
            return (Seq)this.object;
        }
        if (this.object instanceof Resource && this.model.contains((Resource)this.object, RDF.type, RDF.Seq)) {
            return new SeqImpl((Resource)this.object, this.model);
        }
        throw new RDFException(15);
    }

    public String getLanguage() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getLanguage();
        }
        throw new RDFException(15);
    }

    public boolean getWellFormed() throws RDFException {
        if (this.object instanceof Literal) {
            return ((Literal)this.object).getWellFormed();
        }
        throw new RDFException(15);
    }

    public Statement set(boolean bl) throws RDFException {
        this.replace(new LiteralImpl(bl));
        return this;
    }

    public Statement set(long l) throws RDFException {
        this.replace(new LiteralImpl(l));
        return this;
    }

    public Statement set(char c) throws RDFException {
        this.replace(new LiteralImpl(c));
        return this;
    }

    public Statement set(float f) throws RDFException {
        this.replace(new LiteralImpl(f));
        return this;
    }

    public Statement set(double d) throws RDFException {
        this.replace(new LiteralImpl(d));
        return this;
    }

    public Statement set(String string) throws RDFException {
        this.replace(new LiteralImpl(string));
        return this;
    }

    public Statement set(String string, boolean bl) throws RDFException {
        this.replace(new LiteralImpl(string, bl));
        return this;
    }

    public Statement set(String string, String string2) throws RDFException {
        this.replace(new LiteralImpl(string, string2));
        return this;
    }

    public Statement set(String string, String string2, boolean bl) throws RDFException {
        this.replace(new LiteralImpl(string, string2, bl));
        return this;
    }

    public Statement set(RDFNode rDFNode) throws RDFException {
        this.replace(rDFNode);
        return this;
    }

    public Statement set(Object object) throws RDFException {
        if (object instanceof RDFNode) {
            this.replace((RDFNode)object);
        } else {
            this.replace(new LiteralImpl(object.toString()));
        }
        return this;
    }

    protected void replace(RDFNode rDFNode) throws RDFException {
        if (this.model == null) {
            throw new RDFException(1);
        }
        this.model.remove(this);
        this.model.add(this.subject, this.predicate, rDFNode);
        this.object = rDFNode;
    }

    public String toString() {
        String string = "[" + this.subject.toString() + ", " + this.predicate.toString() + ", ";
        string = this.object instanceof Resource ? string + "Resource<" + ((Resource)this.object).toString() + ">" : string + "Literal<" + ((Literal)this.object).toString() + ">";
        return string + "]";
    }

    public boolean equals(Object object) {
        return object instanceof Statement && this.subject.equals(((Statement)object).getSubject()) && this.predicate.equals(((Statement)object).getPredicate()) && this.object.equals(((Statement)object).getObject());
    }

    public Resource removeProperties() throws RDFException {
        if (this.model != null) {
            super.removeProperties();
            return this;
        }
        throw new RDFException(1);
    }

    public Statement remove() throws RDFException {
        if (this.model != null) {
            this.model.remove(this);
            return this;
        }
        throw new RDFException(1);
    }

    public boolean isReified() throws RDFException {
        if (this.model != null) {
            return this.model.isReified(this);
        }
        throw new RDFException(1);
    }

    public Resource port(Model model) throws RDFException {
        if (this.model == model) {
            return this;
        }
        StatementImpl statementImpl = new StatementImpl(this.subject, this.predicate, this.object, model);
        statementImpl.id = this.id;
        return statementImpl;
    }
}

