/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.client.Oscar;

public class Main {
    private static final Logger LOG = Logger.getLogger((String)"org.walluck.oscar.client.Main");

    public static void main(String[] args) {
        AIMSession sess = null;
        Oscar oscar = new Oscar();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        String command = null;
        StringTokenizer st = null;
        block4: while (true) {
            try {
                block5: while (true) {
                    String sn;
                    String group;
                    String buddy;
                    String dest;
                    String msg;
                    System.out.print("\nOSCAR CONSOLE (Enter '?' for help)> ");
                    line = br.readLine();
                    if (line != null) {
                        st = new StringTokenizer(line = line.trim(), " ");
                        if (!st.hasMoreTokens()) continue;
                        command = st.nextToken().toLowerCase();
                    }
                    if (command == null) continue;
                    if (command.equals("?")) {
                        System.out.println("Command help:");
                        System.out.println("q - quit");
                        System.out.println("m <nick> <message> - send <message> to <nick>");
                        System.out.println("s [away message|status] - set away [away message|status]");
                        System.out.println("a <nick> <group> - add <nick> to <group> in your buddy list");
                        System.out.println("d <nick> <group> - delete <nick> from <group> in your buddy list");
                        System.out.println("o <nick> <group> - move <nick> to <group> in your buddy list");
                        System.out.println("p - print buddy list");
                        System.out.println("e - check your AOL email");
                        System.out.println("l - login with <name> <password>");
                        System.out.println("v - show about and memory information");
                        System.out.println("c <chat> <message> - send <message> to <chat>");
                        System.out.println("j <chat> - join <chat>");
                        System.out.println("i <nick> <chat> - invite <nick> to join <chat>");
                        System.out.println("f <file> <nick> - send <file> to <nick>");
                        System.out.println("t <script> - execute <script>");
                        System.out.println("r <nick> [message] - start Trillian encypted session with <nick>, send [message]");
                        System.out.println("b <nick> - get <nick>'s info");
                        System.out.println("h <enc> <message> - set profile with <enc> and <message>");
                        continue;
                    }
                    if (command.startsWith("q")) {
                        AIMConnection.killAllInSess(sess);
                        System.exit(0);
                        continue;
                    }
                    if (command.startsWith("h")) {
                        String enc = st.nextToken();
                        msg = "";
                        while (st.hasMoreTokens()) {
                            msg = msg + st.nextToken() + " ";
                        }
                        msg = msg.trim();
                        oscar.setInfo(sess, enc, msg);
                        continue;
                    }
                    if (command.startsWith("b")) {
                        String nick = st.nextToken();
                        oscar.getInfo(sess, nick);
                        continue;
                    }
                    if (command.startsWith("m")) {
                        dest = st.nextToken();
                        msg = "";
                        if (!st.hasMoreTokens()) continue;
                        msg = st.nextToken();
                        while (st.hasMoreTokens()) {
                            msg = msg + " " + st.nextToken();
                        }
                        if (dest == null || msg == null) continue;
                        if (!sess.isICQ()) {
                            oscar.sendIM(sess, dest.trim(), msg.trim(), oscar.getAIMCaps());
                            continue;
                        }
                        oscar.sendIM(sess, dest.trim(), msg.trim(), Oscar.getICQCaps());
                        continue;
                    }
                    if (command.startsWith("s")) {
                        String awaymsg = null;
                        if (st.hasMoreTokens()) {
                            awaymsg = st.nextToken();
                            while (st.hasMoreTokens()) {
                                awaymsg = awaymsg + " " + st.nextToken();
                            }
                        }
                        if (awaymsg != null) {
                            awaymsg = awaymsg.trim();
                        }
                        if (awaymsg != null && (awaymsg.equals(" ") || awaymsg.length() == 0)) {
                            awaymsg = null;
                        }
                        if (!sess.isICQ()) {
                            oscar.setAwayAIM(sess, awaymsg);
                            continue;
                        }
                        oscar.setAwayICQ(sess, awaymsg);
                        continue;
                    }
                    if (command.startsWith("a")) {
                        buddy = null;
                        group = null;
                        if (st.hasMoreTokens()) {
                            buddy = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            group = st.nextToken();
                        }
                        if (buddy == null || group == null) continue;
                        oscar.addBuddy(sess, buddy.trim(), group.trim());
                        continue;
                    }
                    if (command.startsWith("d")) {
                        buddy = null;
                        group = null;
                        if (st.hasMoreTokens()) {
                            buddy = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            group = st.nextToken();
                        }
                        if (buddy == null) continue;
                        oscar.removeBuddy(sess, buddy.trim(), group);
                        continue;
                    }
                    if (command.startsWith("o")) {
                        buddy = null;
                        String oldGroup = null;
                        String newGroup = null;
                        if (st.hasMoreTokens()) {
                            buddy = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            oldGroup = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            newGroup = st.nextToken();
                        }
                        if (buddy == null || oldGroup == null || newGroup == null) continue;
                        oscar.moveBuddy(sess, buddy.trim(), oldGroup.trim(), newGroup.trim());
                        continue;
                    }
                    if (command.startsWith("n")) {
                        String oldGroup = null;
                        String newGroup = null;
                        if (st.hasMoreTokens()) {
                            oldGroup = st.nextToken();
                        }
                        if (st.hasMoreTokens()) {
                            newGroup = st.nextToken();
                        }
                        if (oldGroup == null || newGroup == null) continue;
                        oscar.renameGroup(sess, oldGroup, newGroup);
                        continue;
                    }
                    if (command.startsWith("p")) {
                        oscar.printBuddyList();
                        continue;
                    }
                    if (command.startsWith("e")) {
                        oscar.checkMail(sess);
                        continue;
                    }
                    if (command.startsWith("l")) {
                        if (st.countTokens() != 2) break block4;
                        sn = st.nextToken();
                        String password = st.nextToken();
                        sess = new AIMSession();
                        oscar.setSN(sn);
                        sess.setSN(sn);
                        char first = sn.charAt(0);
                        if (Character.isDigit(first)) {
                            sess.setICQ(true);
                        }
                        oscar.setPassword(password);
                        sess.init();
                        oscar.login(sess, sn);
                        continue;
                    }
                    if (command.startsWith("v")) {
                        System.out.println();
                        System.out.println(AIMUtil.about());
                        System.out.println(AIMUtil.memInfo());
                        continue;
                    }
                    if (command.startsWith("c")) {
                        dest = st.nextToken();
                        msg = "";
                        if (!st.hasMoreTokens()) continue;
                        msg = st.nextToken();
                        while (true) {
                            if (!st.hasMoreTokens()) continue block5;
                            msg = msg + " " + st.nextToken();
                        }
                    }
                    if (command.startsWith("j")) {
                        String chat = st.nextToken();
                        oscar.join(sess, chat);
                        continue;
                    }
                    if (command.startsWith("i")) {
                        sn = st.nextToken();
                        String roomName = st.nextToken();
                        oscar.invite(sess, sn, roomName);
                        continue;
                    }
                    if (command.startsWith("f")) {
                        sn = st.nextToken();
                        String file = st.nextToken();
                        oscar.sendFile(sess, sn, file);
                        continue;
                    }
                    if (command.startsWith("g")) {
                        sn = st.nextToken();
                        oscar.getFile(sess, sn);
                        continue;
                    }
                    if (command.startsWith("r")) {
                        sn = st.nextToken();
                        msg = "";
                        while (st.hasMoreTokens()) {
                            msg = msg + st.nextToken() + " ";
                        }
                        if (msg.length() > 0) {
                            msg = msg.substring(0, msg.length() - 1);
                        }
                        oscar.trillianEncryption(sess, sn, msg.length() > 0 ? msg : null);
                        continue;
                    }
                    if (!command.startsWith("t")) continue;
                    String script = st.nextToken();
                    sess.getScriptInterpreter().executeScriptFile(script);
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"IOException", (Throwable)ioe);
                continue;
            }
            catch (NoSuchElementException nsee) {
                LOG.error((Object)"NoSuchElementException", (Throwable)nsee);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Exception", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

