/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.atom;

import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomCollectionAdapterRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@DoPrivileged
public class AtomCollectionAdapterRegistryImpl
implements AtomCollectionAdapterRegistry {
    private static Log _log = LogFactoryUtil.getLog(AtomCollectionAdapterRegistryImpl.class);
    private Map<String, AtomCollectionAdapter<?>> _atomCollectionAdapters = new ConcurrentHashMap();

    public AtomCollectionAdapter<?> getAtomCollectionAdapter(String collectionName) {
        return this._atomCollectionAdapters.get(collectionName);
    }

    public List<AtomCollectionAdapter<?>> getAtomCollectionAdapters() {
        return ListUtil.fromMapValues(this._atomCollectionAdapters);
    }

    public void register(AtomCollectionAdapter<?> atomCollectionAdapter) {
        if (this._atomCollectionAdapters.containsKey(atomCollectionAdapter.getCollectionName())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Duplicate collection name " + atomCollectionAdapter.getCollectionName()));
            }
            return;
        }
        this._atomCollectionAdapters.put(atomCollectionAdapter.getCollectionName(), atomCollectionAdapter);
    }

    public void unregister(AtomCollectionAdapter<?> atomCollectionAdapter) {
        this._atomCollectionAdapters.remove(atomCollectionAdapter.getCollectionName());
    }
}

