/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.cluster.clusterlink.messaging;

import com.liferay.portal.cache.ehcache.EhcachePortalCacheManager;
import com.liferay.portal.dao.orm.hibernate.region.LiferayEhcacheRegionFactory;
import com.liferay.portal.dao.orm.hibernate.region.SingletonLiferayEhcacheRegionFactory;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventType;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class ClusterLinkPortalCacheClusterListener
extends BaseMessageListener {
    private static final String _MULTI_VM_PORTAL_CACHE_MANAGER_BEAN_NAME = "com.liferay.portal.kernel.cache.MultiVMPortalCacheManager";
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkPortalCacheClusterListener.class);
    private CacheManager _hibernateCacheManager;
    private CacheManager _portalCacheManager;

    public ClusterLinkPortalCacheClusterListener() {
        LiferayEhcacheRegionFactory liferayEhcacheRegionFactory = SingletonLiferayEhcacheRegionFactory.getInstance();
        this._hibernateCacheManager = liferayEhcacheRegionFactory.getCacheManager();
        EhcachePortalCacheManager ehcachePortalCacheManager = (EhcachePortalCacheManager)PortalBeanLocatorUtil.locate((String)_MULTI_VM_PORTAL_CACHE_MANAGER_BEAN_NAME);
        this._portalCacheManager = ehcachePortalCacheManager.getEhcacheManager();
    }

    protected void doReceive(Message message) throws Exception {
        byte[] data = (byte[])message.getPayload();
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(data));
        PortalCacheClusterEvent portalCacheClusterEvent = (PortalCacheClusterEvent)deserializer.readObject();
        if (portalCacheClusterEvent == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Payload is null");
            }
            return;
        }
        String cacheName = portalCacheClusterEvent.getCacheName();
        Ehcache ehcache = this._portalCacheManager.getEhcache(cacheName);
        if (ehcache == null && this._hibernateCacheManager != null) {
            ehcache = this._hibernateCacheManager.getEhcache(cacheName);
        }
        if (ehcache != null) {
            PortalCacheClusterEventType portalCacheClusterEventType = portalCacheClusterEvent.getEventType();
            if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
                ehcache.removeAll(true);
            } else if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.PUT) || portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.UPDATE)) {
                Serializable elementKey = portalCacheClusterEvent.getElementKey();
                Serializable elementValue = portalCacheClusterEvent.getElementValue();
                if (elementValue == null) {
                    ehcache.remove(elementKey, true);
                } else {
                    ehcache.put(new Element(elementKey, elementValue), true);
                }
            } else {
                ehcache.remove(portalCacheClusterEvent.getElementKey(), true);
            }
        }
    }
}

