/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.Reader;

public class DerbyDB
extends BaseDB {
    private static final String[] _DERBY = new String[]{"--", "1", "0", "'1970-01-01-00.00.00.000000'", "current timestamp", " blob", " blob", " smallint", " timestamp", " double", " integer", " bigint", " varchar(4000)", " clob", " varchar", " generated always as identity", "commit"};
    private static final boolean _SUPPORTS_ALTER_COLUMN_NAME = false;
    private static final boolean _SUPPORTS_ALTER_COLUMN_TYPE = false;
    private static Log _log = LogFactoryUtil.getLog(DerbyDB.class);
    private static DerbyDB _instance = new DerbyDB();

    public static DB getInstance() {
        return _instance;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = this.removeNull(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    @Override
    public boolean isSupportsAlterColumnName() {
        return false;
    }

    @Override
    public boolean isSupportsAlterColumnType() {
        return false;
    }

    protected DerbyDB() {
        super("derby");
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        String suffix = this.getSuffix(population);
        StringBundler sb = new StringBundler(14);
        sb.append("drop database ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(";\n");
        if (population != 0) {
            sb.append("connect to ");
            sb.append(databaseName);
            sb.append(";\n");
            sb.append(this.getCreateTablesContent(sqlDir, suffix));
            sb.append("\n\n");
            sb.append(this.readFile(String.valueOf(sqlDir) + "/indexes/indexes-derby.sql"));
            sb.append("\n\n");
            sb.append(this.readFile(String.valueOf(sqlDir) + "/sequences/sequences-derby.sql"));
        }
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "derby";
    }

    @Override
    protected String[] getTemplate() {
        return _DERBY;
    }

    @Override
    protected String reword(String data) throws IOException {
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));
        StringBundler sb = new StringBundler();
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (line.startsWith("alter_column_name ") || line.startsWith("alter_column_type ")) {
                line = "-- " + line;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("This statement is not supported by Derby: " + line));
                }
            } else if (line.startsWith("alter_table_name ")) {
                String[] template = this.buildTableNameTokens(line);
                line = StringUtil.replace((String)"alter table @old-table@ to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
            } else if (line.contains("drop index")) {
                String[] tokens = StringUtil.split((String)line, (char)' ');
                line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
            }
            sb.append(line);
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        return sb.toString();
    }
}

