/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ModuleFrameworkClassLoader
extends URLClassLoader {
    private ClassLoader _systemClassLoader;

    public ModuleFrameworkClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this._systemClassLoader != null) {
            url = this._systemClassLoader.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> systemURLs = null;
        if (this._systemClassLoader != null) {
            systemURLs = this._systemClassLoader.getResources(name);
        }
        urls.addAll(this._buildURLs(systemURLs));
        Enumeration<URL> localURLs = this.findResources(name);
        urls.addAll(this._buildURLs(localURLs));
        Enumeration<URL> parentURLs = null;
        ClassLoader parentClassLoader = this.getParent();
        if (parentClassLoader != null) {
            parentURLs = parentClassLoader.getResources(name);
        }
        urls.addAll(this._buildURLs(parentURLs));
        return new Enumeration<URL>(urls){
            final Iterator<URL> iterator;
            {
                this.iterator = list.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            if (this._systemClassLoader != null) {
                try {
                    clazz = this._systemClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private List<URL> _buildURLs(Enumeration<URL> url) {
        if (url == null) {
            return new ArrayList<URL>();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (url.hasMoreElements()) {
            urls.add(url.nextElement());
        }
        return urls;
    }
}

