/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi;

import com.liferay.portal.kernel.concurrent.ConcurrentHashSet;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIConfiguration;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistry;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryValidator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManagerUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SPIRegistryImpl
implements SPIRegistry {
    private static Log _log = LogFactoryUtil.getLog(SPIRegistryImpl.class);
    private SPI _errorSPI;
    private Set<String> _excludedPortletIds = new ConcurrentHashSet();
    private Lock _lock = new ReentrantLock();
    private Map<SPI, String[]> _portletIds = new ConcurrentHashMap<SPI, String[]>();
    private Map<String, SPI> _portletSPIs = new ConcurrentHashMap<String, SPI>();
    private Map<SPI, String[]> _servletContextNames = new ConcurrentHashMap<SPI, String[]>();
    private Map<String, SPI> _servletContextSPIs = new ConcurrentHashMap<String, SPI>();
    private SPIRegistryValidator _spiRegistryValidator;

    public void addExcludedPortletId(String portletId) {
        this._excludedPortletIds.add(portletId);
    }

    public SPI getErrorSPI() {
        return this._errorSPI;
    }

    public Set<String> getExcludedPortletIds() {
        return this._excludedPortletIds;
    }

    public SPI getPortletSPI(String portletId) {
        if (this._excludedPortletIds.contains(portletId)) {
            return null;
        }
        SPI spi = this._portletSPIs.get(portletId);
        if (this._spiRegistryValidator != null) {
            spi = this._spiRegistryValidator.validatePortletSPI(portletId, spi);
        }
        return spi;
    }

    public SPI getServletContextSPI(String servletContextName) {
        SPI spi = this._servletContextSPIs.get(servletContextName);
        if (this._spiRegistryValidator != null) {
            spi = this._spiRegistryValidator.validateServletContextSPI(servletContextName, spi);
        }
        return spi;
    }

    public void registerSPI(SPI spi) throws RemoteException {
        String[] servletContextNames;
        ArrayList<String> portletIds = new ArrayList<String>();
        SPIConfiguration spiConfiguration = spi.getSPIConfiguration();
        String[] stringArray = spiConfiguration.getPortletIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
            if (portlet == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Skip unknown portlet id " + portletId));
                }
            } else {
                portletIds.add(portletId);
            }
            ++n2;
        }
        String[] stringArray2 = servletContextNames = spiConfiguration.getServletContextNames();
        int n3 = servletContextNames.length;
        n = 0;
        while (n < n3) {
            String servletContextName = stringArray2[n];
            PortletApp portletApp = PortletLocalServiceUtil.getPortletApp((String)servletContextName);
            if (portletApp == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Skip unknown servlet context name " + servletContextName));
                }
            } else {
                List portlets = portletApp.getPortlets();
                for (Portlet portlet : portlets) {
                    portletIds.add(portlet.getPortletId());
                }
            }
            ++n;
        }
        this._lock.lock();
        try {
            for (String portletId : portletIds) {
                this._portletSPIs.put(portletId, spi);
            }
            this._portletIds.put(spi, portletIds.toArray(new String[portletIds.size()]));
            stringArray2 = servletContextNames;
            n3 = servletContextNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String servletContextName = stringArray2[n4];
                this._servletContextSPIs.put(servletContextName, spi);
                ++n4;
            }
            this._servletContextNames.put(spi, (String[])servletContextNames.clone());
            ServiceBeanAopCacheManagerUtil.reset();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void removeExcludedPortletId(String portletId) {
        this._excludedPortletIds.remove(portletId);
    }

    public void setErrorSPI(SPI errorSPI) {
        this._errorSPI = errorSPI;
    }

    public void setSPIRegistryValidator(SPIRegistryValidator spiRegistryValidator) {
        this._spiRegistryValidator = spiRegistryValidator;
    }

    public void unregisterSPI(SPI spi) {
        this._lock.lock();
        try {
            String[] servletContextNames;
            int n;
            String[] portletIds = this._portletIds.remove(spi);
            if (portletIds != null) {
                String[] stringArray = portletIds;
                n = portletIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String portletId = stringArray[n2];
                    this._portletSPIs.remove(portletId);
                    ++n2;
                }
            }
            if ((servletContextNames = this._servletContextNames.remove(spi)) != null) {
                String[] stringArray = servletContextNames;
                int n3 = servletContextNames.length;
                n = 0;
                while (n < n3) {
                    String servletContextName = stringArray[n];
                    this._servletContextSPIs.remove(servletContextName);
                    ++n;
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }
}

