/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.job;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.JobStateSerializeUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;

public class MessageSenderJob
implements Job {
    private static Log _log = LogFactoryUtil.getLog(MessageSenderJob.class);
    private static MethodKey _deleteJobMethodKey = new MethodKey(SchedulerEngineHelperUtil.class, "delete", new Class[]{String.class, String.class, StorageType.class});

    public void execute(JobExecutionContext jobExecutionContext) {
        try {
            this.doExecute(jobExecutionContext);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to execute job", (Throwable)e2);
        }
    }

    protected void doExecute(JobExecutionContext jobExecutionContext) throws Exception {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String destinationName = jobDataMap.getString("DESTINATION_NAME");
        String messageJSON = (String)jobDataMap.get((Object)"MESSAGE");
        Message message = null;
        message = messageJSON == null ? new Message() : (Message)JSONFactoryUtil.deserialize((String)messageJSON);
        message.put("DESTINATION_NAME", (Object)destinationName);
        JobKey jobKey = jobDetail.getKey();
        Map jobStateMap = (Map)jobDataMap.get((Object)"JOB_STATE");
        JobState jobState = JobStateSerializeUtil.deserialize((Map)jobStateMap);
        StorageType storageType = StorageType.valueOf((String)jobDataMap.getString("STORAGE_TYPE"));
        if (jobExecutionContext.getNextFireTime() == null) {
            message.put("DISABLE", (Object)true);
            if (PropsValues.CLUSTER_LINK_ENABLED && storageType.equals((Object)StorageType.MEMORY_CLUSTERED)) {
                this.notifyClusterMember(jobKey, storageType);
            }
            if (storageType.equals((Object)StorageType.PERSISTED)) {
                Scheduler scheduler = jobExecutionContext.getScheduler();
                scheduler.deleteJob(jobKey);
            }
        }
        message.put("JOB_NAME", (Object)jobKey.getName());
        message.put("JOB_STATE", (Object)jobState);
        message.put("GROUP_NAME", (Object)jobKey.getGroup());
        message.put("STORAGE_TYPE", (Object)storageType);
        MessageBusUtil.sendMessage((String)destinationName, (Message)message);
    }

    protected void notifyClusterMember(JobKey jobKey, StorageType storageType) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_deleteJobMethodKey, new Object[]{jobKey.getName(), jobKey.getGroup(), storageType});
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)methodHandler, (boolean)true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }
}

