/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.servletcontextinclude;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.taglib.util.ThemeUtil;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletContextIncludeFilter
extends BasePortalFilter {
    private static Log _log = LogFactoryUtil.getLog(ServletContextIncludeFilter.class);

    @Override
    public boolean isFilterEnabled() {
        return super.isFilterEnabled() && PropsValues.THEME_JSP_OVERRIDE_ENABLED;
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        Theme theme;
        block6: {
            block5: {
                theme = this.getTheme(request);
                if (theme != null) break block5;
                return false;
            }
            Boolean strict = (Boolean)request.getAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT");
            if (strict == null || !strict.booleanValue()) break block6;
            return false;
        }
        try {
            FilterConfig filterConfig = this.getFilterConfig();
            ServletContext servletContext = filterConfig.getServletContext();
            String portletId = ThemeUtil.getPortletId((HttpServletRequest)request);
            String uri = (String)request.getAttribute("INVOKER_FILTER_URI");
            if (theme.resourceExists(servletContext, portletId, uri)) {
                request.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_PATH", (Object)uri);
                request.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_THEME", (Object)theme);
                return true;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return false;
    }

    protected Theme getTheme(HttpServletRequest request) throws Exception {
        String themeId = ParamUtil.getString((HttpServletRequest)request, (String)"themeId");
        if (Validator.isNotNull((String)themeId)) {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            return ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)false);
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"plid");
        if (plid <= 0L) {
            plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        }
        if (plid > 0L) {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            return layout.getTheme();
        }
        Theme theme = (Theme)request.getAttribute("THEME");
        if (theme != null) {
            return theme;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            return themeDisplay.getTheme();
        }
        LayoutSet layoutSet = (LayoutSet)request.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet != null) {
            return layoutSet.getTheme();
        }
        return null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Theme theme = (Theme)request.getAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_THEME");
        request.setAttribute("THEME", (Object)theme);
        FilterConfig filterConfig = this.getFilterConfig();
        ServletContext servletContext = filterConfig.getServletContext();
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher("/WEB-INF/jsp/_servlet_context_include.jsp");
        requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
    }
}

