/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.weblogic;

import com.liferay.portal.kernel.servlet.MetaInfoCacheServletResponse;
import com.liferay.portal.kernel.servlet.WrapHttpServletResponseFilter;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.weblogic.WebLogicIncludeServletResponse;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WebLogicIncludeFilter
extends BasePortalFilter
implements WrapHttpServletResponseFilter {
    public HttpServletResponse getWrappedHttpServletResponse(HttpServletRequest request, HttpServletResponse response) {
        if (this.isWrap(response)) {
            return new WebLogicIncludeServletResponse(response);
        }
        return response;
    }

    @Override
    public boolean isFilterEnabled() {
        return ServerDetector.isWebLogic();
    }

    protected boolean isWrap(HttpServletResponse response) {
        if (response instanceof WebLogicIncludeServletResponse) {
            return false;
        }
        boolean wrap = false;
        HttpServletResponseWrapper previousResponseWrapper = null;
        while (response instanceof HttpServletResponseWrapper) {
            if (!wrap && response instanceof MetaInfoCacheServletResponse) {
                wrap = true;
            }
            HttpServletResponseWrapper responseWrapper = (HttpServletResponseWrapper)response;
            response = (HttpServletResponse)responseWrapper.getResponse();
            if (responseWrapper instanceof WebLogicIncludeServletResponse) {
                previousResponseWrapper.setResponse((ServletResponse)response);
            }
            previousResponseWrapper = responseWrapper;
        }
        return wrap;
    }
}

