/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.cache.transactional.TransactionalPortalCacheHelper;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.spring.hibernate.LastSessionRecorderUtil;
import com.liferay.portal.spring.transaction.BaseTransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionCommitCallbackUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;

public class CallbackPreferringTransactionExecutor
extends BaseTransactionExecutor {
    @Override
    public Object execute(PlatformTransactionManager platformTransactionManager, TransactionAttribute transactionAttribute, MethodInvocation methodInvocation) throws Throwable {
        CallbackPreferringPlatformTransactionManager callbackPreferringPlatformTransactionManager = (CallbackPreferringPlatformTransactionManager)platformTransactionManager;
        try {
            Object result = callbackPreferringPlatformTransactionManager.execute((TransactionDefinition)transactionAttribute, this.createTransactionCallback(transactionAttribute, methodInvocation));
            if (result instanceof ThrowableHolder) {
                ThrowableHolder throwableHolder = (ThrowableHolder)result;
                throw throwableHolder.getThrowable();
            }
            return result;
        }
        catch (ThrowableHolderException the) {
            throw the.getCause();
        }
    }

    protected TransactionCallback<Object> createTransactionCallback(TransactionAttribute transactionAttribute, MethodInvocation methodInvocation) {
        return new CallbackPreferringTransactionCallback(transactionAttribute, methodInvocation);
    }

    private class CallbackPreferringTransactionCallback
    implements TransactionCallback<Object> {
        private MethodInvocation _methodInvocation;
        private TransactionAttribute _transactionAttribute;

        private CallbackPreferringTransactionCallback(TransactionAttribute transactionAttribute, MethodInvocation methodInvocation) {
            this._transactionAttribute = transactionAttribute;
            this._methodInvocation = methodInvocation;
        }

        public Object doInTransaction(TransactionStatus transactionStatus) {
            boolean newTransaction = transactionStatus.isNewTransaction();
            if (newTransaction) {
                TransactionalPortalCacheHelper.begin();
                TransactionCommitCallbackUtil.pushCallbackList();
            }
            boolean rollback = false;
            try {
                if (newTransaction) {
                    LastSessionRecorderUtil.syncLastSessionState();
                }
                Object object = this._methodInvocation.proceed();
                return object;
            }
            catch (Throwable throwable) {
                if (this._transactionAttribute.rollbackOn(throwable)) {
                    if (newTransaction) {
                        TransactionalPortalCacheHelper.rollback();
                        TransactionCommitCallbackUtil.popCallbackList();
                        EntityCacheUtil.clearLocalCache();
                        FinderCacheUtil.clearLocalCache();
                        rollback = true;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new ThrowableHolderException(throwable);
                }
                ThrowableHolder throwableHolder = new ThrowableHolder(throwable);
                return throwableHolder;
            }
            finally {
                if (newTransaction && !rollback) {
                    TransactionalPortalCacheHelper.commit();
                    CallbackPreferringTransactionExecutor.this.invokeCallbacks();
                }
            }
        }
    }

    protected static class ThrowableHolder {
        private Throwable _throwable;

        public ThrowableHolder(Throwable throwable) {
            this._throwable = throwable;
        }

        public Throwable getThrowable() {
            return this._throwable;
        }
    }

    protected static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable cause) {
            super(cause);
        }
    }
}

