/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSSourceProcessor
extends BaseSourceProcessor {
    private Pattern _multipleVarsOnSingleLinePattern = Pattern.compile("\t+var \\w+\\, ");

    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\js\\aui\\**", "**\\js\\editor\\**", "**\\js\\misc\\**", "**\\tools\\**", "**\\VAADIN\\**"};
        String[] includes = new String[]{"**\\*.js"};
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    @Override
    protected String format(String fileName) throws Exception {
        Matcher matcher;
        File file = new File("./" + fileName);
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        String content = fileUtil.read(file);
        String newContent = this.trimContent(content, false);
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{"else{", "for(", "function (", "if(", "while(", "){\n", "= new Array();", "= new Object();"}, (String[])new String[]{"else {", "for (", "function(", "if (", "while (", ") {\n", "= [];", "= {};"});
        while ((matcher = this._multipleVarsOnSingleLinePattern.matcher(newContent)).find()) {
            String match = matcher.group();
            int pos = match.indexOf("var ");
            StringBundler sb = new StringBundler(4);
            sb.append(match.substring(0, match.length() - 2));
            sb.append(";");
            sb.append("\n");
            sb.append(match.substring(0, pos + 4));
            newContent = StringUtil.replace((String)newContent, (String)match, (String)sb.toString());
        }
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        this.checkLanguageKeys(fileName, newContent, languageKeyPattern);
        if (this.isAutoFix() && newContent != null && !content.equals(newContent)) {
            fileUtil.write(file, newContent);
            sourceFormatterHelper.printError(fileName, file);
        }
        return newContent;
    }
}

