/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import java.io.File;
import java.util.List;

public class TLDSourceProcessor
extends BaseSourceProcessor {
    @Override
    protected void format() throws Exception {
        String[] excludes = new String[]{"**\\bin\\**", "**\\classes\\**", "**\\WEB-INF\\tld\\**"};
        String[] includes = new String[]{"**\\*.tld"};
        List<String> fileNames = this.getFileNames(excludes, includes);
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    @Override
    protected String format(String fileName) throws Exception {
        File file = new File("./" + fileName);
        String content = fileUtil.read(file);
        String newContent = this.trimContent(content, false);
        if (this.isAutoFix() && newContent != null && !content.equals(newContent)) {
            fileUtil.write(file, newContent);
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            sourceFormatterHelper.printError(fileName, file);
        }
        return newContent;
    }
}

