/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.upgrade.UpgradeProcessUtil;
import com.liferay.portal.upgrade.v6_2_0.util.DLFileEntryTypeTable;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    protected void deleteChecksumDirectory() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select distinct companyId from DLFileEntry");
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                try {
                    DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)"checksum");
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void deleteTempDirectory() {
        try {
            DLStoreUtil.deleteDirectory((long)0L, (long)0L, (String)"liferay_temp/");
        }
        catch (Exception exception) {}
    }

    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter table DLFileEntryType add fileEntryTypeKey STRING");
            this.runSQL("alter_column_type DLFileEntryType name STRING null");
        }
        catch (SQLException sQLException) {
            this.upgradeTable("DLFileEntryType", DLFileEntryTypeTable.TABLE_COLUMNS, "create table DLFileEntryType (uuid_ VARCHAR(75) null,fileEntryTypeId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,fileEntryTypeKey VARCHAR(75) null,name STRING null,description STRING null)", DLFileEntryTypeTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateFileEntryTypes();
        this.deleteChecksumDirectory();
        this.deleteTempDirectory();
    }

    protected String getUserName(long userId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            String string;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select firstName, middleName, lastName from User_ where userId = ?");
                ps.setLong(1, userId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                String firstName = rs.getString("firstName");
                String middleName = rs.getString("middleName");
                String lastName = rs.getString("lastName");
                FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                string = fullNameGenerator.getFullName(firstName, middleName, lastName);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return string;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return "";
    }

    protected String localize(long companyId, String content, String key) throws Exception {
        String languageId = UpgradeProcessUtil.getDefaultLanguageId(companyId);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        HashMap<Locale, String> localizationMap = new HashMap<Locale, String>();
        localizationMap.put(locale, content);
        return LocalizationUtil.updateLocalization(localizationMap, (String)"", (String)key, (String)languageId);
    }

    protected void updateFileEntryType(long fileEntryTypeId, long companyId, String fileEntryTypeKey, String name, String description) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update DLFileEntryType set fileEntryTypeKey = ?, name = ?, description = ? where fileEntryTypeId = ?");
            ps.setString(1, fileEntryTypeKey);
            ps.setString(2, this.localize(companyId, name, "Name"));
            ps.setString(3, this.localize(companyId, description, "Description"));
            ps.setLong(4, fileEntryTypeId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateFileEntryTypes() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select fileEntryTypeId, companyId, name, description from DLFileEntryType");
            rs = ps.executeQuery();
            while (rs.next()) {
                long fileEntryTypeId = rs.getLong("fileEntryTypeId");
                long companyId = rs.getLong("companyId");
                String name = GetterUtil.getString((String)rs.getString("name"));
                String description = rs.getString("description");
                if (fileEntryTypeId == 0L) {
                    name = "basic-document";
                }
                this.updateFileEntryType(fileEntryTypeId, companyId, StringUtil.toUpperCase((String)name), name, description);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

