/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JavaScriptBundleUtil {
    private static final String _CACHE_NAME = JavaScriptBundleUtil.class.getName();
    private static PortalCache<String, String[]> _portalCache = SingleVMPoolUtil.getCache((String)_CACHE_NAME);

    public static void clearCache() {
        _portalCache.removeAll();
    }

    public static String[] getFileNames(String bundleId) {
        String[] fileNames = (String[])_portalCache.get((Serializable)((Object)bundleId));
        if (fileNames == null) {
            ArrayList<String> fileNamesList = new ArrayList<String>();
            List<String> dependencies = JavaScriptBundleUtil._getDependencies(bundleId, (List<String>)new UniqueList());
            for (String dependency : dependencies) {
                String[] dependencyFileNames;
                String[] stringArray = dependencyFileNames = PropsUtil.getArray(dependency);
                int n = dependencyFileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String dependencyFileName = stringArray[n2];
                    fileNamesList.add(dependencyFileName);
                    ++n2;
                }
            }
            fileNames = fileNamesList.toArray(new String[fileNamesList.size()]);
            _portalCache.put((Serializable)((Object)bundleId), (Object)fileNames);
        }
        return fileNames;
    }

    private static List<String> _getDependencies(String bundleId, List<String> dependencies) {
        String[] bundleDependencies;
        if (!ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)bundleId)) {
            return dependencies;
        }
        String[] stringArray = bundleDependencies = PropsUtil.getArray("javascript.bundle.dependencies", new Filter(bundleId));
        int n = bundleDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleDependency = stringArray[n2];
            Object[] bundleDependencyDependencies = PropsUtil.getArray("javascript.bundle.dependencies", new Filter(bundleDependency));
            if (!ArrayUtil.contains((Object[])bundleDependencyDependencies, (Object)bundleId)) {
                JavaScriptBundleUtil._getDependencies(bundleDependency, dependencies);
            }
            dependencies.add(bundleDependency);
            ++n2;
        }
        dependencies.add(bundleId);
        return dependencies;
    }
}

