/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;

public class OpenIdUtil {
    private static OpenIdUtil _instance = new OpenIdUtil();
    private ConsumerManager _manager;

    public static ConsumerManager getConsumerManager() {
        _instance._initialize();
        return OpenIdUtil._instance._manager;
    }

    public static String getScreenName(String openId) {
        String result = OpenIdUtil.normalize(openId);
        if (result.startsWith("http://")) {
            result = result.substring("http://".length());
        }
        if (result.startsWith("https://")) {
            result = result.substring("https://".length());
        }
        result = StringUtil.replace((String)result, (String[])new String[]{"/", "_"}, (String[])new String[]{".", "."});
        return result;
    }

    public static boolean isEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "open.id.auth.enabled", PropsValues.OPEN_ID_AUTH_ENABLED);
    }

    public static String normalize(String identity) {
        String result = identity;
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void _initialize() {
        if (this._manager != null) {
            return;
        }
        this._manager = new ConsumerManager();
        this._manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        this._manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
    }
}

