/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.TransactionAttribute;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.service.persistence.PortalPreferencesPersistence;
import com.liferay.portal.service.persistence.PortalPreferencesUtil;
import com.liferay.portlet.BasePreferencesImpl;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.Preference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.portlet.ReadOnlyException;

public class PortalPreferencesImpl
extends BasePreferencesImpl
implements Cloneable,
PortalPreferences,
Serializable {
    public static final TransactionAttribute TRANSACTION_ATTRIBUTE;
    private static final String _RANDOM_KEY = "r";
    private static Log _log;
    private boolean _signedIn;
    private long _userId;

    static {
        TransactionAttribute.Builder builder = new TransactionAttribute.Builder();
        builder.setRollbackForClasses(new Class[]{PortalException.class, SystemException.class});
        TRANSACTION_ATTRIBUTE = builder.build();
        _log = LogFactoryUtil.getLog(PortalPreferencesImpl.class);
    }

    public PortalPreferencesImpl() {
        this(0L, 0, null, Collections.emptyMap(), false);
    }

    public PortalPreferencesImpl(long ownerId, int ownerType, String xml, Map<String, Preference> preferences, boolean signedIn) {
        super(ownerId, ownerType, xml, preferences);
        this._signedIn = signedIn;
    }

    public PortalPreferencesImpl clone() {
        return new PortalPreferencesImpl(this.getOwnerId(), this.getOwnerType(), this.getOriginalXML(), new HashMap<String, Preference>(this.getOriginalPreferences()), this.isSignedIn());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortalPreferencesImpl)) {
            return false;
        }
        PortalPreferencesImpl portalPreferences = (PortalPreferencesImpl)obj;
        return this.getOwnerId() == portalPreferences.getOwnerId() && this.getOwnerType() == portalPreferences.getOwnerType() && this.getPreferences().equals(portalPreferences.getPreferences());
    }

    public long getUserId() {
        return this._userId;
    }

    @Override
    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String namespace, String key, String defaultValue) {
        key = this._encodeKey(namespace, key);
        return super.getValue(key, defaultValue);
    }

    public String[] getValues(String namespace, String key) {
        return this.getValues(namespace, key, null);
    }

    public String[] getValues(String namespace, String key, String[] defaultValue) {
        key = this._encodeKey(namespace, key);
        return super.getValues(key, defaultValue);
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (long)this.getOwnerId());
        hashCode = HashUtil.hash((int)hashCode, (int)this.getOwnerType());
        hashCode = HashUtil.hash((int)hashCode, this.getPreferences());
        return hashCode;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    @Override
    public void reset(final String key) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(key);
        }
        try {
            this.validateStore(new Callable<Void>(){

                @Override
                public Void call() {
                    Map<String, Preference> modifiedPreferences = PortalPreferencesImpl.this.getModifiedPreferences();
                    modifiedPreferences.remove(key);
                    return null;
                }
            }, key);
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    public void resetValues(String namespace) {
        Map<String, Preference> preferences = this.getPreferences();
        try {
            for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(namespace) || this.isReadOnly(key)) continue;
                this.reset(key);
            }
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setValue(final String namespace, final String key, final String value) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        try {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws ReadOnlyException {
                    String encodedKey = PortalPreferencesImpl.this._encodeKey(namespace, key);
                    if (value == null) {
                        PortalPreferencesImpl.this.reset(encodedKey);
                    } else {
                        PortalPreferencesImpl.super.setValue(encodedKey, value);
                    }
                    return null;
                }
            };
            if (this._signedIn) {
                this.validateStore(callable, this._encodeKey(namespace, key));
            } else {
                callable.call();
            }
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    public void setValues(final String namespace, final String key, final String[] values) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        try {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws ReadOnlyException {
                    String encodedKey = PortalPreferencesImpl.this._encodeKey(namespace, key);
                    if (values == null) {
                        PortalPreferencesImpl.this.reset(encodedKey);
                    } else {
                        PortalPreferencesImpl.super.setValues(encodedKey, values);
                    }
                    return null;
                }
            };
            if (this._signedIn) {
                this.validateStore(callable, this._encodeKey(namespace, key));
            } else {
                callable.call();
            }
        }
        catch (ConcurrentModificationException cme) {
            throw cme;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    private Callable<Boolean> _createValidateCallable(final String[] originalValues, final String key) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                com.liferay.portal.model.PortalPreferences preferences = PortalPreferencesUtil.fetchByO_O((long)PortalPreferencesImpl.this.getOwnerId(), (int)PortalPreferencesImpl.this.getOwnerType(), (boolean)false);
                PortalPreferencesPersistence portalPreferencesPersistence = PortalPreferencesUtil.getPersistence();
                Session session = portalPreferencesPersistence.getCurrentSession();
                session.evict((Object)preferences);
                preferences = (com.liferay.portal.model.PortalPreferences)session.get(com.liferay.portal.model.impl.PortalPreferencesImpl.class, (Serializable)Long.valueOf(preferences.getPrimaryKey()), LockMode.UPGRADE);
                PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)PortalPreferencesImpl.this.getOwnerId(), (int)PortalPreferencesImpl.this.getOwnerType(), (String)preferences.getPreferences());
                String originalXML = PortalPreferencesImpl.this.getOriginalXML();
                if (originalXML.equals(preferences.getPreferences())) {
                    PortalPreferencesImpl.this.store();
                    return true;
                }
                if (!Arrays.equals(originalValues, portalPreferencesImpl.getValues(key, (String[])null))) {
                    return false;
                }
                PortalPreferencesImpl.this.reset();
                PortalPreferencesImpl.this.setOriginalPreferences(portalPreferencesImpl.getOriginalPreferences());
                PortalPreferencesImpl.this.setOriginalXML(preferences.getPreferences());
                return null;
            }
        };
    }

    protected void validateStore(Callable<?> callable, String key) throws Throwable {
        String[] originalValues;
        Boolean result;
        do {
            originalValues = super.getValues(key, null);
            callable.call();
        } while ((result = (Boolean)TransactionInvokerUtil.invoke((TransactionAttribute)TRANSACTION_ATTRIBUTE, this._createValidateCallable(originalValues, key))) == null);
        if (!result.booleanValue()) {
            PortalPreferencesWrapperCacheUtil.remove(this.getOwnerId(), this.getOwnerType());
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void store() throws IOException {
        try {
            PortalPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (PortalPreferences)this);
        }
        catch (SystemException se) {
            throw new IOException(se.getMessage());
        }
    }

    private String _encodeKey(String namespace, String key) {
        if (Validator.isNull((String)namespace)) {
            return key;
        }
        return namespace.concat("#").concat(key);
    }
}

