/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.util.SimplePool;

public class VelocityPortlet
extends GenericPortlet {
    private static SimplePool _writerPool = new SimplePool(40);
    private String _actionTemplateId;
    private String _editTemplateId;
    private String _helpTemplateId;
    private String _portletContextName;
    private String _resourceTemplateId;
    private String _viewTemplateId;

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
            return;
        }
        try {
            this.mergeTemplate(this._editTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e2) {
            throw new PortletException((Throwable)e2);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.mergeTemplate(this._helpTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e2) {
            throw new PortletException((Throwable)e2);
        }
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.mergeTemplate(this._viewTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e2) {
            throw new PortletException((Throwable)e2);
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext portletContext = portletConfig.getPortletContext();
        this._portletContextName = portletContext.getPortletContextName();
        this._actionTemplateId = this.getTemplateId(this.getInitParameter("action-template"));
        this._editTemplateId = this.getTemplateId(this.getInitParameter("edit-template"));
        this._helpTemplateId = this.getTemplateId(this.getInitParameter("help-template"));
        this._resourceTemplateId = this.getTemplateId(this.getInitParameter("resource-template"));
        this._viewTemplateId = this.getTemplateId(this.getInitParameter("view-template"));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        if (Validator.isNull((String)this._actionTemplateId)) {
            return;
        }
        try {
            this.mergeTemplate(this._actionTemplateId, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
        catch (Exception e2) {
            throw new PortletException((Throwable)e2);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (Validator.isNull((String)this._resourceTemplateId)) {
            super.serveResource(resourceRequest, resourceResponse);
            return;
        }
        try {
            this.mergeTemplate(this._resourceTemplateId, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        catch (Exception e2) {
            throw new PortletException((Throwable)e2);
        }
    }

    protected String getTemplateId(String name) {
        if (Validator.isNull((String)name)) {
            return name;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(this._portletContextName);
        sb.append("_SERVLET_CONTEXT_");
        sb.append("/html");
        sb.append(name);
        return sb.toString();
    }

    protected void mergeTemplate(String templateId, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"vm", (String)templateId);
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + templateId);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)templateResource, (boolean)false);
        this.prepareTemplate(template, portletRequest, portletResponse);
        this.mergeTemplate(templateId, template, portletRequest, portletResponse);
    }

    protected void mergeTemplate(String templateId, Template template, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            mimeResponse.setContentType(portletRequest.getResponseContentType());
        }
        VelocityWriter velocityWriter = null;
        try {
            velocityWriter = (VelocityWriter)_writerPool.get();
            Object output = null;
            if (portletResponse instanceof MimeResponse) {
                MimeResponse mimeResponse = (MimeResponse)portletResponse;
                output = mimeResponse.getWriter();
            } else {
                output = UnsyncPrintWriterPool.borrow((OutputStream)System.out);
            }
            if (velocityWriter == null) {
                velocityWriter = new VelocityWriter((Writer)output, 4096, true);
            } else {
                velocityWriter.recycle((Writer)output);
            }
            template.processTemplate((Writer)velocityWriter);
        }
        catch (Throwable throwable) {
            try {
                if (velocityWriter != null) {
                    velocityWriter.flush();
                    velocityWriter.recycle(null);
                    _writerPool.put((Object)velocityWriter);
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (velocityWriter != null) {
                velocityWriter.flush();
                velocityWriter.recycle(null);
                _writerPool.put((Object)velocityWriter);
            }
        }
        catch (Exception exception) {}
    }

    protected void prepareTemplate(Template template, PortletRequest portletRequest, PortletResponse portletResponse) {
        template.put("portletConfig", (Object)this.getPortletConfig());
        template.put("portletContext", (Object)this.getPortletContext());
        template.put("preferences", (Object)portletRequest.getPreferences());
        template.put("userInfo", portletRequest.getAttribute("javax.portlet.userinfo"));
        template.put("portletRequest", (Object)portletRequest);
        if (portletRequest instanceof ActionRequest) {
            template.put("actionRequest", (Object)portletRequest);
        } else if (portletRequest instanceof RenderRequest) {
            template.put("renderRequest", (Object)portletRequest);
        } else {
            template.put("resourceRequest", (Object)portletRequest);
        }
        template.put("portletResponse", (Object)portletResponse);
        if (portletResponse instanceof ActionResponse) {
            template.put("actionResponse", (Object)portletResponse);
        } else if (portletRequest instanceof RenderResponse) {
            template.put("renderResponse", (Object)portletResponse);
        } else {
            template.put("resourceResponse", (Object)portletResponse);
        }
    }
}

