/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;

public class DLFileShortcutPermission {
    public static void check(PermissionChecker permissionChecker, DLFileShortcut dlFileShortcut, String actionId) throws PortalException {
        if (!DLFileShortcutPermission.contains(permissionChecker, dlFileShortcut, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long fileShortcutId, String actionId) throws PortalException, SystemException {
        if (!DLFileShortcutPermission.contains(permissionChecker, fileShortcutId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileShortcut dlFileShortcut, String actionId) {
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFileShortcut.getGroupId(), (String)DLFileShortcut.class.getName(), (long)dlFileShortcut.getFileShortcutId(), (String)"20", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(dlFileShortcut.getCompanyId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), dlFileShortcut.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(dlFileShortcut.getGroupId(), DLFileShortcut.class.getName(), dlFileShortcut.getFileShortcutId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileShortcutId, String actionId) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = DLFileShortcutLocalServiceUtil.getFileShortcut((long)fileShortcutId);
        return DLFileShortcutPermission.contains(permissionChecker, dlFileShortcut, actionId);
    }
}

