/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.sites.action.ActionUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportLayoutsAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ExportLayoutsAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            long[] layoutIds = this.getLayoutIds((PortletRequest)actionRequest);
            DateRange dateRange = ExportImportHelperUtil.getDateRange((PortletRequest)actionRequest, (long)groupId, (boolean)privateLayout, (long)0L, null, (String)"all");
            if (Validator.isNotNull((String)cmd)) {
                LayoutServiceUtil.exportLayoutsAsFileInBackground((String)fileName, (long)groupId, (boolean)privateLayout, (long[])layoutIds, (Map)actionRequest.getParameterMap(), (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate(), (String)fileName);
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            String pagesRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
            this.sendRedirect(actionRequest, actionResponse, pagesRedirect);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchGroupException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.layouts_admin.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.export_layouts"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/export_layouts_processes.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected long[] getLayoutIds(PortletRequest portletRequest) throws Exception {
        UniqueList layouts = new UniqueList();
        Map layoutIdMap = ExportImportHelperUtil.getLayoutIdMap((PortletRequest)portletRequest);
        for (Map.Entry entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = (Boolean)entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            if (!includeChildren) continue;
            layouts.addAll(layout.getAllChildren());
        }
        return ExportImportHelperUtil.getLayoutIds((List)layouts);
    }
}

