/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.social;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;

public class MBMessageActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{MBMessage.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getBody(SocialActivity activity, ServiceContext serviceContext) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)activity.getClassPK());
        if (message.getCategoryId() <= 0L) {
            return "";
        }
        StringBundler sb = new StringBundler(4);
        sb.append(serviceContext.getPortalURL());
        sb.append(serviceContext.getPathMain());
        sb.append("/message_boards/find_category?mbCategoryId=");
        sb.append(message.getCategoryId());
        String categoryLink = sb.toString();
        categoryLink = this.addNoSuchEntryRedirect(categoryLink, MBCategory.class.getName(), message.getCategoryId(), serviceContext);
        return this.wrapLink(categoryLink, "go-to-category", serviceContext);
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/message_boards/find_message?messageId=" + activity.getClassPK();
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) {
        String userName = this.getUserName(activity.getUserId(), serviceContext);
        String receiverUserName = "";
        if (activity.getReceiverUserId() > 0L) {
            receiverUserName = this.getUserName(activity.getReceiverUserId(), serviceContext);
        }
        return new Object[]{groupName, userName, receiverUserName, this.wrapLink(link, title)};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        long receiverUserId = activity.getReceiverUserId();
        if (activityType == 1) {
            if (receiverUserId == 0L) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-message-boards-message-add-message";
                }
                return "activity-message-boards-message-add-message-in";
            }
            if (Validator.isNull((String)groupName)) {
                return "activity-message-boards-message-reply-message";
            }
            return "activity-message-boards-message-reply-message-in";
        }
        if (activityType == 2 && receiverUserId > 0L) {
            if (Validator.isNull((String)groupName)) {
                return "activity-message-boards-message-reply-message";
            }
            return "activity-message-boards-message-reply-message-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)activity.getClassPK());
        return MBMessagePermission.contains(permissionChecker, message.getMessageId(), actionId);
    }
}

