/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.network.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portlet.network.model.Whois;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.Socket;

public class WhoisWebCacheItem
implements WebCacheItem {
    public static final String WHOIS_SERVER = "whois.geektools.com";
    public static final int WHOIS_SERVER_PORT = 43;
    private static final long _REFRESH_TIME = 86400000L;
    private String _domain;

    public WhoisWebCacheItem(String domain) {
        this._domain = domain;
    }

    public Object convert(String key) throws WebCacheException {
        Whois whois = null;
        try {
            Socket socket = new Socket(WHOIS_SERVER, 43);
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(socket.getInputStream()));
            PrintStream out = new PrintStream(socket.getOutputStream());
            out.println(this._domain);
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("Results ")) break;
                sb.append(line).append("\n");
            }
            unsyncBufferedReader.close();
            socket.close();
            whois = new Whois(this._domain, StringUtil.replace((String)sb.toString().trim(), (String)"\n\n", (String)"\n"));
        }
        catch (Exception e2) {
            throw new WebCacheException(String.valueOf(this._domain) + " " + e2.toString());
        }
        return whois;
    }

    public long getRefreshTime() {
        return 86400000L;
    }
}

