/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.rolesadmin.lar;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.ResourceTypePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.security.permission.PermissionConversionFilter;
import com.liferay.portal.security.permission.PermissionConverterUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.service.ResourceTypePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.rolesadmin.lar.ImportExportPermissionConversionFilter;
import java.util.List;
import java.util.Map;

public class RoleStagedModelDataHandler
extends BaseStagedModelDataHandler<Role> {
    public static final String[] CLASS_NAMES = new String[]{Role.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(RoleStagedModelDataHandler.class);
    private PermissionConversionFilter _permissionConversionFilter = new ImportExportPermissionConversionFilter();

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Role role = RoleLocalServiceUtil.fetchRoleByUuidAndCompanyId((String)uuid, (long)group.getCompanyId());
        if (role != null) {
            RoleLocalServiceUtil.deleteRole((Role)role);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Role role) {
        return role.getName();
    }

    protected void deleteRolePermissions(PortletDataContext portletDataContext, Role importedRole) throws SystemException {
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)importedRole.getRoleId(), (int[])new int[]{1, 3}, (int)-1, (int)-1);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            ResourcePermissionLocalServiceUtil.deleteResourcePermission((ResourcePermission)resourcePermission);
        }
        List groupResourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)importedRole.getRoleId(), (int[])new int[]{2}, (int)-1, (int)-1);
        for (ResourcePermission groupResourcePermission : groupResourcePermissions) {
            long groupId = GetterUtil.getLong((String)groupResourcePermission.getPrimKey());
            if (groupId != portletDataContext.getCompanyGroupId() && groupId != portletDataContext.getUserPersonalSiteGroupId()) continue;
            ResourcePermissionLocalServiceUtil.deleteResourcePermission((ResourcePermission)groupResourcePermission);
        }
        List<ResourceTypePermission> resourceTypePermissions = this.getResourceTypePermissions(portletDataContext, importedRole);
        for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
            ResourceTypePermissionLocalServiceUtil.deleteResourceTypePermission((ResourceTypePermission)resourceTypePermission);
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Role role) throws Exception {
        String permissionsPath = ExportImportPathUtil.getModelPath((StagedModel)role, (String)"permissions.xml");
        List permissions = PermissionConverterUtil.convertPermissions((Role)role, (PermissionConversionFilter)this._permissionConversionFilter);
        String xml = portletDataContext.toXML((Object)permissions);
        portletDataContext.addZipEntry(permissionsPath, xml);
        Element roleElement = portletDataContext.getExportDataElement((ClassedModel)role);
        portletDataContext.addClassedModel(roleElement, ExportImportPathUtil.getModelPath((StagedModel)role), (ClassedModel)role);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Role role) throws Exception {
        long userId = portletDataContext.getUserId(role.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)role);
        Role existingRole = RoleLocalServiceUtil.fetchRoleByUuidAndCompanyId((String)role.getUuid(), (long)portletDataContext.getCompanyId());
        if (existingRole == null) {
            existingRole = RoleLocalServiceUtil.fetchRole((long)portletDataContext.getCompanyId(), (String)role.getName());
        }
        Role importedRole = null;
        if (existingRole == null) {
            serviceContext.setUuid(role.getUuid());
            importedRole = RoleLocalServiceUtil.addRole((long)userId, null, (long)0L, (String)role.getName(), (Map)role.getTitleMap(), (Map)role.getDescriptionMap(), (int)role.getType(), (String)role.getSubtype(), (ServiceContext)serviceContext);
        } else {
            importedRole = RoleLocalServiceUtil.updateRole((long)existingRole.getRoleId(), (String)role.getName(), (Map)role.getTitleMap(), (Map)role.getDescriptionMap(), (String)role.getSubtype(), (ServiceContext)serviceContext);
            this.deleteRolePermissions(portletDataContext, importedRole);
        }
        String permissionsPath = ExportImportPathUtil.getModelPath((StagedModel)role, (String)"permissions.xml");
        List permissions = (List)portletDataContext.getZipEntryAsObject(permissionsPath);
        for (Permission permission : permissions) {
            if (ResourceBlockLocalServiceUtil.isSupported((String)permission.getName())) {
                this.importResourceBlock(portletDataContext, importedRole, permission);
                continue;
            }
            this.importResourcePermissions(portletDataContext, importedRole, permission);
        }
        portletDataContext.importClassedModel((ClassedModel)role, (ClassedModel)importedRole);
    }

    protected List<ResourceTypePermission> getResourceTypePermissions(PortletDataContext portletDataContext, Role importedRole) throws SystemException {
        long[] permissibleGroupIds;
        DynamicQuery dynamicQuery = ResourceTypePermissionLocalServiceUtil.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)portletDataContext.getCompanyId()));
        Disjunction junction = RestrictionsFactoryUtil.disjunction();
        long[] lArray = new long[4];
        lArray[1] = portletDataContext.getCompanyId();
        lArray[2] = portletDataContext.getCompanyGroupId();
        lArray[3] = portletDataContext.getUserPersonalSiteGroupId();
        long[] lArray2 = permissibleGroupIds = lArray;
        int n = permissibleGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long permissibleGroupId = lArray2[n2];
            Property property = PropertyFactoryUtil.forName((String)"groupId");
            junction.add(property.eq((Object)permissibleGroupId));
            ++n2;
        }
        dynamicQuery.add((Criterion)junction);
        Property roleIdProperty = PropertyFactoryUtil.forName((String)"roleId");
        dynamicQuery.add(roleIdProperty.eq((Object)importedRole.getRoleId()));
        return ResourceTypePermissionLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
    }

    protected void importResourceBlock(PortletDataContext portletDataContext, Role importedRole, Permission permission) throws PortalException, SystemException {
        int scope = permission.getScope();
        if (scope == 1) {
            ResourceBlockLocalServiceUtil.addCompanyScopePermission((long)portletDataContext.getCompanyId(), (String)permission.getName(), (long)importedRole.getRoleId(), (String)permission.getActionId());
        } else if (scope == 2) {
            long groupId = portletDataContext.getCompanyGroupId();
            long sourceGroupId = GetterUtil.getLong((String)permission.getPrimKey());
            if (sourceGroupId == portletDataContext.getSourceUserPersonalSiteGroupId()) {
                groupId = portletDataContext.getUserPersonalSiteGroupId();
            }
            ResourceBlockLocalServiceUtil.addGroupScopePermission((long)portletDataContext.getCompanyId(), (long)groupId, (String)permission.getName(), (long)importedRole.getRoleId(), (String)permission.getActionId());
        } else if (scope == 3) {
            ResourceBlockLocalServiceUtil.addGroupScopePermission((long)portletDataContext.getCompanyId(), (long)0L, (String)permission.getName(), (long)importedRole.getRoleId(), (String)permission.getActionId());
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)"Individually scoped permissions are not exported");
        }
    }

    protected void importResourcePermissions(PortletDataContext portletDataContext, Role importedRole, Permission permission) throws PortalException, SystemException {
        int scope = permission.getScope();
        if (scope == 1) {
            ResourcePermissionServiceUtil.addResourcePermission((long)portletDataContext.getCompanyGroupId(), (long)portletDataContext.getCompanyId(), (String)permission.getName(), (int)scope, (String)String.valueOf(portletDataContext.getCompanyId()), (long)importedRole.getRoleId(), (String)permission.getActionId());
        } else if (scope == 2) {
            long groupId = portletDataContext.getCompanyGroupId();
            long sourceGroupId = GetterUtil.getLong((String)permission.getPrimKey());
            if (sourceGroupId == portletDataContext.getSourceUserPersonalSiteGroupId()) {
                groupId = portletDataContext.getUserPersonalSiteGroupId();
            }
            ResourcePermissionServiceUtil.addResourcePermission((long)groupId, (long)portletDataContext.getCompanyId(), (String)permission.getName(), (int)2, (String)String.valueOf(groupId), (long)importedRole.getRoleId(), (String)permission.getActionId());
        } else if (scope == 3) {
            ResourcePermissionServiceUtil.addResourcePermission((long)0L, (long)portletDataContext.getCompanyId(), (String)permission.getName(), (int)3, (String)String.valueOf(0L), (long)importedRole.getRoleId(), (String)permission.getActionId());
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)"Individually scoped permissions are not imported");
        }
    }
}

