/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications.thread;

import java.util.List;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.databook.shared.RunningJob;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusNotificationThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(JobStatusNotificationThread.class);
    private RunningJob jobDescriptor;
    private List<GenericItemBean> recipients;
    private NotificationsManager nm;

    public JobStatusNotificationThread(RunningJob jobDescriptor, List<GenericItemBean> recipients, NotificationsManager nm) {
        this.jobDescriptor = jobDescriptor;
        this.recipients = recipients;
        this.nm = nm;
    }

    @Override
    public void run() {
        logger.debug("Starting job notification thread. Recipients of this notification are " + this.recipients);
        for (GenericItemBean recipient : this.recipients) {
            try {
                String userIdToNotify = recipient.getName();
                this.nm.notifyJobStatus(userIdToNotify, this.jobDescriptor);
            }
            catch (Exception e) {
                logger.error("Failed to send notification", (Throwable)e);
            }
        }
        logger.debug("Notification job thread ended");
    }
}

