/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications.thread;

import java.util.ArrayList;
import java.util.List;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageNotificationsThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(MessageNotificationsThread.class);
    private String messageText;
    private String messageId;
    private String subjectText;
    private List<GenericItemBean> recipients;
    private NotificationsManager nm;

    public MessageNotificationsThread(List<GenericItemBean> recipients, String postId, String subjectText, String messageText, NotificationsManager nm) {
        this.messageId = postId;
        this.messageText = messageText;
        this.subjectText = subjectText;
        this.recipients = recipients;
        this.nm = nm;
    }

    @Override
    public void run() {
        try {
            String checkedText = MessageNotificationsThread.escapeHtmlAndTransformNewlines(this.messageText);
            for (GenericItemBean userToNotify : this.recipients) {
                String userIdToNotify = userToNotify.getName();
                List<Object> temp = new ArrayList(this.recipients.size());
                temp = this.copy(this.recipients);
                temp.remove(userToNotify);
                String[] otherRecipientsFullNames = this.getFullNamesOnly(temp);
                if (!this.nm.notifyMessageReceived(userIdToNotify, this.messageId, this.subjectText, checkedText, otherRecipientsFullNames)) continue;
                _log.trace("Sending message notifications to: " + userIdToNotify + " OK");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getFullNamesOnly(List<GenericItemBean> toCopy) {
        String[] toReturn = new String[toCopy.size()];
        int i = 0;
        for (GenericItemBean item : toCopy) {
            toReturn[i] = item.getAlternativeName();
            ++i;
        }
        return toReturn;
    }

    private List<GenericItemBean> copy(List<GenericItemBean> toCopy) {
        ArrayList<GenericItemBean> toReturn = new ArrayList<GenericItemBean>();
        for (GenericItemBean genericItemBean : toCopy) {
            toReturn.add(genericItemBean);
        }
        return toReturn;
    }

    private static String escapeHtmlAndTransformNewlines(String html) {
        if (html == null) {
            return null;
        }
        String toReturn = html.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        toReturn = toReturn.replaceAll("(\r\n|\n)", " <br/> ");
        toReturn = toReturn.replaceAll("\\s\\s", "&nbsp;&nbsp;");
        return toReturn;
    }
}

