/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.scribe.utils.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private static final String EMPTY = "";
    private int code;
    private String body;
    private InputStream stream;
    private Map<String, String> headers;

    Response(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
            this.code = connection.getResponseCode();
            this.headers = this.parseHeaders(connection);
            this.stream = this.wasSuccessful() ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (UnknownHostException e) {
            this.code = 404;
            this.body = EMPTY;
        }
    }

    private String parseBodyContents() {
        this.body = StreamUtils.getStreamContents(this.getStream());
        return this.body;
    }

    private Map<String, String> parseHeaders(HttpURLConnection conn) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : conn.getHeaderFields().keySet()) {
            headers.put(key, conn.getHeaderFields().get(key).get(0));
        }
        return headers;
    }

    private boolean wasSuccessful() {
        return this.getCode() >= 200 && this.getCode() < 400;
    }

    public String getBody() {
        return this.body != null ? this.body : this.parseBodyContents();
    }

    public InputStream getStream() {
        return this.stream;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }
}

