/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.test;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.URLField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ReaderURLThread
extends Thread {
    private URI locator = null;
    private int readCount;

    public ReaderURLThread(URI locator, int readCount) {
        this.locator = locator;
        this.readCount = readCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is, int bufferSize, String encoding) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[bufferSize];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    @Override
    public void run() {
        try {
            ForwardReader reader = new ForwardReader(this.locator);
            reader.setIteratorTimeout(60L);
            reader.setIteratorTimeUnit(TimeUnit.SECONDS);
            System.out.println("starting reading");
            int count = 0;
            Iterator iter = reader.iterator();
            while (true) {
                long startRec = System.currentTimeMillis();
                if (!iter.hasNext()) {
                    System.out.println("no more after " + (System.currentTimeMillis() - startRec));
                    break;
                }
                if (count == this.readCount) break;
                GenericRecord rec = (GenericRecord)iter.next();
                long endRec = System.currentTimeMillis();
                if (rec == null) {
                    throw new TimeoutException("timeout while waiting for next");
                }
                ++count;
                Field f = rec.getField("ThisIsTheField");
                long startAvail = System.currentTimeMillis();
                rec.makeAvailable();
                System.out.println("rec");
                String string = ReaderURLThread.convertStreamToString(((URLField)f).getInputStream(), 1024, "UTF-8");
            }
            System.out.println("read total " + count);
            System.out.println("reader closing");
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

