/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.security;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.gcube.application.framework.core.security.JaasCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPAuthenticationModule {
    private static final Logger logger = LoggerFactory.getLogger(LDAPAuthenticationModule.class);
    public static String LDAP_HOST = "LDAP_HOST";
    public static String BASE_DN = "BASE_DN";
    private String contextName = "Gridsphere";

    public boolean checkAuthentication(String username, String password) {
        logger.info("beginning authentication for " + username);
        try {
            LoginContext loginContext = new LoginContext(this.contextName, new JaasCallbackHandler(username, password));
            loginContext.login();
            return true;
        }
        catch (SecurityException e) {
            logger.error("Exception:", (Throwable)e);
            return false;
        }
        catch (LoginException e) {
            logger.error("Exception:", (Throwable)e);
            return false;
        }
    }
}

