/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType1;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType5;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType6;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType7;

public abstract class PDShadingResources
implements COSObjectable {
    private COSDictionary dictionary;
    private COSArray background = null;
    private PDRectangle bBox = null;
    private PDColorSpace colorspace = null;
    public static final int SHADING_TYPE1 = 1;
    public static final int SHADING_TYPE2 = 2;
    public static final int SHADING_TYPE3 = 3;
    public static final int SHADING_TYPE4 = 4;
    public static final int SHADING_TYPE5 = 5;
    public static final int SHADING_TYPE6 = 6;
    public static final int SHADING_TYPE7 = 7;

    public PDShadingResources() {
        this.dictionary = new COSDictionary();
    }

    public PDShadingResources(COSDictionary shadingDictionary) {
        this.dictionary = shadingDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.dictionary;
    }

    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public String getType() {
        return COSName.SHADING.getName();
    }

    public void setShadingType(int shadingType) {
        this.dictionary.setInt(COSName.SHADING_TYPE, shadingType);
    }

    public abstract int getShadingType();

    public void setBackground(COSArray newBackground) {
        this.background = newBackground;
        this.dictionary.setItem(COSName.BACKGROUND, (COSBase)newBackground);
    }

    public COSArray getBackground() {
        if (this.background == null) {
            this.background = (COSArray)this.dictionary.getDictionaryObject(COSName.BACKGROUND);
        }
        return this.background;
    }

    public PDRectangle getBBox() {
        COSArray array;
        if (this.bBox == null && (array = (COSArray)this.dictionary.getDictionaryObject(COSName.BBOX)) != null) {
            this.bBox = new PDRectangle(array);
        }
        return this.bBox;
    }

    public void setBBox(PDRectangle newBBox) {
        this.bBox = newBBox;
        if (this.bBox == null) {
            this.dictionary.removeItem(COSName.BBOX);
        } else {
            this.dictionary.setItem(COSName.BBOX, (COSBase)this.bBox.getCOSArray());
        }
    }

    public void setAntiAlias(boolean antiAlias) {
        this.dictionary.setBoolean(COSName.ANTI_ALIAS, antiAlias);
    }

    public boolean getAntiAlias() {
        return this.dictionary.getBoolean(COSName.ANTI_ALIAS, false);
    }

    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorspace == null) {
            COSBase colorSpaceDictionary = this.dictionary.getDictionaryObject(COSName.CS, COSName.COLORSPACE);
            this.colorspace = PDColorSpaceFactory.createColorSpace(colorSpaceDictionary);
        }
        return this.colorspace;
    }

    public void setColorSpace(PDColorSpace newColorspace) {
        this.colorspace = newColorspace;
        if (newColorspace != null) {
            this.dictionary.setItem(COSName.COLORSPACE, newColorspace.getCOSObject());
        } else {
            this.dictionary.removeItem(COSName.COLORSPACE);
        }
    }

    public static PDShadingResources create(COSDictionary resourceDictionary) throws IOException {
        PDShadingResources shading = null;
        int shadingType = resourceDictionary.getInt(COSName.SHADING_TYPE, 0);
        switch (shadingType) {
            case 1: {
                shading = new PDShadingType1(resourceDictionary);
                break;
            }
            case 2: {
                shading = new PDShadingType2(resourceDictionary);
                break;
            }
            case 3: {
                shading = new PDShadingType3(resourceDictionary);
                break;
            }
            case 4: {
                shading = new PDShadingType4(resourceDictionary);
                break;
            }
            case 5: {
                shading = new PDShadingType5(resourceDictionary);
                break;
            }
            case 6: {
                shading = new PDShadingType6(resourceDictionary);
                break;
            }
            case 7: {
                shading = new PDShadingType7(resourceDictionary);
                break;
            }
            default: {
                throw new IOException("Error: Unknown shading type " + shadingType);
            }
        }
        return shading;
    }
}

