/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.rss;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.rss.Entry;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public abstract class Feed {
    protected List<Entry> m_entries = new ArrayList<Entry>();
    protected String m_feedURL;
    protected String m_channelTitle;
    protected String m_channelDescription;
    protected String m_channelLanguage;
    protected WikiContext m_wikiContext;
    protected String m_mode = "wiki";

    public Feed(WikiContext context) {
        this.m_wikiContext = context;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public void addEntry(Entry e) {
        this.m_entries.add(e);
    }

    public abstract String getString();

    public String getChannelDescription() {
        return this.m_channelDescription;
    }

    public void setChannelDescription(String description) {
        this.m_channelDescription = description;
    }

    public String getChannelLanguage() {
        return this.m_channelLanguage;
    }

    public void setChannelLanguage(String language) {
        this.m_channelLanguage = language;
    }

    public String getChannelTitle() {
        return this.m_channelTitle;
    }

    public void setChannelTitle(String title) {
        this.m_channelTitle = title;
    }

    public String getFeedURL() {
        return this.m_feedURL;
    }

    public void setFeedURL(String feedurl) {
        this.m_feedURL = feedurl;
    }

    protected String getMimeType(ServletContext c, String name) {
        String type = c.getMimeType(name);
        if (type == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public static String format(String s) {
        if (s != null) {
            s = TextUtil.replaceString(s, "&", "&amp;");
            s = TextUtil.replaceString(s, "<", "&lt;");
            s = TextUtil.replaceString(s, ">", "&gt;");
            return s.trim();
        }
        return null;
    }
}

