/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.ui;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.SessionMonitor;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.ui.WikiRequestWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class WikiServletFilter
implements Filter {
    protected static final Logger log = Logger.getLogger(WikiServletFilter.class);
    protected WikiEngine m_engine = null;

    public void init(FilterConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        this.m_engine = WikiEngine.getInstance(context, null);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (chain == null) {
            throw new ServletException("FilterChain is null, even if it should not be.  Please report this to the jspwiki development team.");
        }
        if (this.m_engine == null) {
            PrintWriter out = response.getWriter();
            out.print("<html><head><title>Fatal problem with JSPWiki</title></head>");
            out.print("<body>");
            out.print("<h1>JSPWiki has not been started</h1>");
            out.print("<p>JSPWiki is not running.  This is probably due to a configuration error in your jspwiki.properties file, ");
            out.print("or a problem with your servlet container.  Please double-check everything before issuing a bug report ");
            out.print("at jspwiki.org.</p>");
            out.print("<p>We apologize for the inconvenience.  No, really, we do.  We're trying to ");
            out.print("JSPWiki as easy as we can, but there is only so much we have time to test ");
            out.print("platforms.</p>");
            out.print("<p>Please go to the <a href='Install.jsp'>installer</a> to continue.</p>");
            out.print("</body></html>");
            return;
        }
        Object httpRequest = (HttpServletRequest)request;
        httpRequest.setCharacterEncoding(this.m_engine.getContentEncoding());
        if (this.m_engine.getBaseURL().length() == 0 && !httpRequest.getRequestURI().endsWith("Install.jsp")) {
            PrintWriter out = response.getWriter();
            out.print("<html><head><title>JSPWiki installation start</title></head>");
            out.print("<body>");
            out.print("<h1>JSPWiki installation</h1>");
            out.print("<p>Hello!  It appears that this is your first jspwiki installation.");
            out.print("(Or, you have removed jspwiki.baseURL from your property file.) ");
            out.print("Therefore, you will need to start the installation process. ");
            out.print("Please <a href='Install.jsp'>continue to the installer</a>.");
            out.print("</p>");
            out.print("<p>If you just used the installer, then please restart your servlet container to get rid of this message.</p>");
            out.print("</body></html>");
            return;
        }
        if (!this.isWrapped(request)) {
            try {
                this.m_engine.getAuthenticationManager().login((HttpServletRequest)httpRequest);
                WikiSession wikiSession = SessionMonitor.getInstance(this.m_engine).find(httpRequest.getSession());
                httpRequest = new WikiRequestWrapper(this.m_engine, (HttpServletRequest)httpRequest);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executed security filters for user=" + wikiSession.getLoginPrincipal().getName() + ", path=" + httpRequest.getRequestURI()));
                }
            }
            catch (WikiSecurityException e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            NDC.push((String)(this.m_engine.getApplicationName() + ":" + httpRequest.getRequestURL()));
            chain.doFilter((ServletRequest)httpRequest, response);
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            NDC.pop();
            NDC.remove();
            throw throwable;
        }
        NDC.pop();
        NDC.remove();
    }

    protected WikiContext getWikiContext(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        WikiContext ctx = (WikiContext)httpRequest.getAttribute("jspwiki.context");
        return ctx;
    }

    private boolean isWrapped(ServletRequest request) {
        while (!(request instanceof WikiRequestWrapper) && request != null && request instanceof HttpServletRequestWrapper) {
            request = ((HttpServletRequestWrapper)request).getRequest();
        }
        return request instanceof WikiRequestWrapper;
    }
}

