/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.json.JSONObject;

public class DictionarySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{Hashtable.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && Dictionary.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!java_class.equals("java.util.Dictionary") && !java_class.equals("java.util.Hashtable")) {
            throw new UnmarshallException("not a Dictionary");
        }
        JSONObject jsonmap = jso.getJSONObject("map");
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m = this.ser.tryUnmarshall(state, null, jsonmap.get(key)).max(m);
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        Hashtable<String, Object> ht = null;
        if (!java_class.equals("java.util.Dictionary") && !java_class.equals("java.util.Hashtable")) {
            throw new UnmarshallException("not a Dictionary");
        }
        ht = new Hashtable<String, Object>();
        JSONObject jsonmap = jso.getJSONObject("map");
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                ht.put(key, this.ser.unmarshall(state, null, jsonmap.get(key)));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage());
        }
        return ht;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        Dictionary ht = (Dictionary)o;
        JSONObject obj = new JSONObject();
        JSONObject mapdata = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            obj.put("javaClass", (Object)o.getClass().getName());
        }
        obj.put("map", (Object)mapdata);
        Object key = null;
        Object val = null;
        try {
            Enumeration en = ht.keys();
            while (en.hasMoreElements()) {
                key = en.nextElement();
                val = ht.get(key);
                mapdata.put(key.toString(), this.ser.marshall(state, val));
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("map key " + key + " " + e.getMessage());
        }
        return obj;
    }
}

