/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf;

import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.ConfigurationException;
import com.germinus.easyconf.ConfigurationLoader;
import com.germinus.easyconf.ConfigurationNotFoundException;
import com.germinus.easyconf.ConfigurationObjectCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ComponentConfiguration {
    private static final Log log = LogFactory.getLog((Class)(class$com$germinus$easyconf$ComponentConfiguration == null ? (class$com$germinus$easyconf$ComponentConfiguration = ComponentConfiguration.class$("com.germinus.easyconf.ComponentConfiguration")) : class$com$germinus$easyconf$ComponentConfiguration));
    private ComponentProperties properties;
    private String componentName;
    private ConfigurationLoader confManager = new ConfigurationLoader();
    private String companyId;
    private Map confObjectsCache = new HashMap();
    static /* synthetic */ Class class$com$germinus$easyconf$ComponentConfiguration;

    public ComponentConfiguration(String componentName) {
        this(null, componentName);
    }

    public ComponentConfiguration(String companyId, String componentName) {
        this.companyId = companyId;
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Object getConfigurationObject() {
        return this.getConfigurationObject("DEFAULT_CONF_OBJECT");
    }

    public Object getConfigurationObject(String confName) {
        if (this.confObjectsCache.get(confName) == null) {
            try {
                ConfigurationObjectCache confObjectCache = this.getConfigurationManager().readConfigurationObject(this.companyId, this.componentName, confName, this.getAvailableProperties());
                log.debug((Object)("Obtained confObjectCache for " + confName + ": " + confObjectCache));
                log.debug((Object)("Its confObjectis " + confObjectCache.getConfigurationObject()));
                this.confObjectsCache.put(confName, confObjectCache);
            }
            catch (IOException e) {
                throw new ConfigurationException(this.componentName, "Error reading object configuration", e);
            }
            catch (SAXException e) {
                throw new ConfigurationException(this.componentName, "Error parsing the XML file", e);
            }
        }
        ConfigurationObjectCache confObject = (ConfigurationObjectCache)this.confObjectsCache.get(confName);
        return confObject.getConfigurationObject();
    }

    public void saveConfigurationObject(Object configurationObject) {
        this.saveConfigurationObject("DEFAULT_CONF_OBJECT", configurationObject);
    }

    public void saveConfigurationObject(String confName, Object configurationObject) {
        ConfigurationObjectCache newConfObject = new ConfigurationObjectCache(configurationObject, null, this.getAvailableProperties(), confName);
        this.getConfigurationManager().saveConfigurationObjectIntoDatabase(configurationObject, this.companyId, this.componentName, confName, this.getAvailableProperties());
        this.confObjectsCache.put(confName, newConfObject);
    }

    private ConfigurationLoader getConfigurationManager() {
        return this.confManager;
    }

    public ComponentProperties getProperties() {
        ComponentProperties properties = this.getAvailableProperties();
        if (!properties.hasBaseConfiguration()) {
            String msg = "The base properties file was not found";
            throw new ConfigurationNotFoundException(this.componentName, msg);
        }
        return properties;
    }

    private ComponentProperties getAvailableProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = this.getConfigurationManager().readPropertiesConfiguration(this.companyId, this.componentName);
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ComponentConfiguration cconf = (ComponentConfiguration)obj;
        return this.componentName.equals(cconf.getComponentName());
    }

    public int hashCode() {
        return this.componentName.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

