/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf;

import com.germinus.easyconf.ConfigurationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.JNDIConfiguration;

public class JndiURL {
    private static final String JNDI_PREFIX = "jndi:";
    private static InitialContext ctx = null;
    private String jndiPrefix;
    private String companyId;
    private String componentName;

    public JndiURL(String jndiPath, String companyId, String componentName) {
        this.jndiPrefix = this.jndiPrefix.substring(JNDI_PREFIX.length());
        this.companyId = companyId;
        this.componentName = componentName;
    }

    private synchronized InitialContext getContext() throws NamingException {
        if (ctx == null) {
            ctx = new InitialContext();
        }
        return ctx;
    }

    public static boolean isJndi(String sourcePath) {
        return sourcePath.startsWith(JNDI_PREFIX);
    }

    public String getPrefix() {
        return this.jndiPrefix;
    }

    public Configuration getConfiguration() {
        try {
            return new JNDIConfiguration(this.getPrefix());
        }
        catch (NamingException e) {
            throw new ConfigurationException("Error loading JNDI configuration for " + this.getPrefix());
        }
    }
}

