/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LineNumberNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LocalVariableNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;

public class MethodNode {
    public int access;
    public String name;
    public String desc;
    public final List exceptions;
    public Attribute attrs;
    public final List instructions;
    public final List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public final List localVariables;
    public final List lineNumbers;
    public Attribute codeAttrs;

    public MethodNode(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.exceptions = new ArrayList();
        this.instructions = new ArrayList();
        this.tryCatchBlocks = new ArrayList();
        this.localVariables = new ArrayList();
        this.lineNumbers = new ArrayList();
        if (exceptions != null) {
            this.exceptions.addAll((Collection)Arrays.asList(exceptions));
        }
        this.attrs = attrs;
    }

    public void accept(ClassVisitor cv) {
        String[] exceptions = new String[this.exceptions.size()];
        this.exceptions.toArray(exceptions);
        CodeVisitor mv = cv.visitMethod(this.access, this.name, this.desc, exceptions, this.attrs);
        if (mv != null && this.instructions.size() > 0) {
            int i = 0;
            while (i < this.instructions.size()) {
                Object insn = this.instructions.get(i);
                if (insn instanceof Label) {
                    mv.visitLabel((Label)insn);
                } else {
                    ((AbstractInsnNode)insn).accept(mv);
                }
                ++i;
            }
            i = 0;
            while (i < this.tryCatchBlocks.size()) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).accept(mv);
                ++i;
            }
            mv.visitMaxs(this.maxStack, this.maxLocals);
            i = 0;
            while (i < this.localVariables.size()) {
                ((LocalVariableNode)this.localVariables.get(i)).accept(mv);
                ++i;
            }
            i = 0;
            while (i < this.lineNumbers.size()) {
                ((LineNumberNode)this.lineNumbers.get(i)).accept(mv);
                ++i;
            }
            Attribute attrs = this.codeAttrs;
            while (attrs != null) {
                mv.visitAttribute(attrs);
                attrs = attrs.next;
            }
        }
    }
}

