/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.cookies;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisHttpCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmisCookieStoreImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<URI, ArrayList<CmisHttpCookie>> storeMap = new HashMap<URI, ArrayList<CmisHttpCookie>>();

    CmisCookieStoreImpl() {
    }

    public void add(URI uri, CmisHttpCookie cookie) {
        if (uri == null || cookie == null) {
            throw new NullPointerException();
        }
        if (this.storeMap.containsKey(uri)) {
            ArrayList<CmisHttpCookie> cookies = this.storeMap.get(uri);
            cookies.remove(cookie);
            cookies.add(cookie);
        } else {
            ArrayList<CmisHttpCookie> cookies = new ArrayList<CmisHttpCookie>();
            cookies.add(cookie);
            this.storeMap.put(uri, cookies);
        }
    }

    public List<CmisHttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("URI is null!");
        }
        ArrayList<CmisHttpCookie> cookies = this.storeMap.get(uri);
        if (cookies == null) {
            cookies = new ArrayList<CmisHttpCookie>();
        } else {
            for (CmisHttpCookie cookie : cookies) {
                if (!cookie.hasExpired()) continue;
                cookies.remove(cookie);
            }
        }
        Set<URI> uris = this.storeMap.keySet();
        for (URI u : uris) {
            if (u.equals(uri)) continue;
            List listCookie = this.storeMap.get(u);
            for (CmisHttpCookie cookie : listCookie) {
                if (!CmisHttpCookie.domainMatches(cookie.getDomain(), uri.getHost())) continue;
                if (cookie.hasExpired()) {
                    listCookie.remove(cookie);
                    continue;
                }
                if (cookie.hasExpired() || cookies.contains(cookie)) continue;
                cookies.add(cookie);
            }
        }
        return cookies;
    }

    public List<CmisHttpCookie> getCookies() {
        ArrayList<CmisHttpCookie> cookies = new ArrayList<CmisHttpCookie>();
        Collection<ArrayList<CmisHttpCookie>> values = this.storeMap.values();
        for (ArrayList<CmisHttpCookie> list : values) {
            for (CmisHttpCookie cookie : list) {
                if (cookie.hasExpired()) {
                    list.remove(cookie);
                    continue;
                }
                if (cookies.contains(cookie)) continue;
                cookies.add(cookie);
            }
        }
        return Collections.unmodifiableList(cookies);
    }

    public List<URI> getURIs() {
        return new ArrayList<URI>(this.storeMap.keySet());
    }

    public boolean remove(URI uri, CmisHttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("Cookie is null!");
        }
        boolean success = false;
        Collection<ArrayList<CmisHttpCookie>> values = this.storeMap.values();
        for (ArrayList<CmisHttpCookie> list : values) {
            if (!list.remove(cookie)) continue;
            success = true;
        }
        return success;
    }

    public boolean removeAll() {
        if (!this.storeMap.isEmpty()) {
            this.storeMap.clear();
        }
        return true;
    }
}

