/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.Collection;
import java.util.List;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.typeconverter.impl.ArrayConverter;
import jodd.util.StringUtil;
import jodd.util.collection.FloatArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayConverter
implements TypeConverter<float[]> {
    protected final TypeConverterManagerBean typeConverterManagerBean;

    public FloatArrayConverter(TypeConverterManagerBean typeConverterManagerBean) {
        this.typeConverterManagerBean = typeConverterManagerBean;
    }

    @Override
    public float[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!valueClass.isArray()) {
            return this.convertValueToArray(value);
        }
        return this.convertArrayToArray(value);
    }

    protected float convertType(Object value) {
        return this.typeConverterManagerBean.convertType(value, Float.TYPE).floatValue();
    }

    protected float[] convertToSingleElementArray(Object value) {
        return new float[]{this.convertType(value)};
    }

    protected float[] convertValueToArray(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            float[] target = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                target[i] = this.convertType(element);
            }
            return target;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            float[] target = new float[collection.size()];
            int i = 0;
            for (Object element : collection) {
                target[i] = this.convertType(element);
                ++i;
            }
            return target;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            FloatArrayList floatArrayList = new FloatArrayList();
            for (Object element : iterable) {
                float convertedValue = this.convertType(element);
                floatArrayList.add(convertedValue);
            }
            return floatArrayList.toArray();
        }
        if (value instanceof CharSequence) {
            String[] strings = StringUtil.splitc((String)value.toString(), (char[])ArrayConverter.NUMBER_DELIMITERS);
            return this.convertArrayToArray(strings);
        }
        return this.convertToSingleElementArray(value);
    }

    protected float[] convertArrayToArray(Object value) {
        float[] result;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (valueComponentType == Float.TYPE) {
            return (float[])value;
        }
        if (valueComponentType.isPrimitive()) {
            result = this.convertPrimitiveArrayToArray(value, valueComponentType);
        } else {
            Object[] array = (Object[])value;
            result = new float[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = this.convertType(array[i]);
            }
        }
        return result;
    }

    protected float[] convertPrimitiveArrayToArray(Object value, Class primitiveComponentType) {
        float[] result;
        block9: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    result = null;
                                    if (primitiveComponentType == float[].class) {
                                        return (float[])value;
                                    }
                                    if (primitiveComponentType != Integer.TYPE) break block8;
                                    int[] array = (int[])value;
                                    result = new float[array.length];
                                    for (int i = 0; i < array.length; ++i) {
                                        result[i] = array[i];
                                    }
                                    break block9;
                                }
                                if (primitiveComponentType != Long.TYPE) break block10;
                                long[] array = (long[])value;
                                result = new float[array.length];
                                for (int i = 0; i < array.length; ++i) {
                                    result[i] = array[i];
                                }
                                break block9;
                            }
                            if (primitiveComponentType != Double.TYPE) break block11;
                            double[] array = (double[])value;
                            result = new float[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = (float)array[i];
                            }
                            break block9;
                        }
                        if (primitiveComponentType != Short.TYPE) break block12;
                        short[] array = (short[])value;
                        result = new float[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            result[i] = array[i];
                        }
                        break block9;
                    }
                    if (primitiveComponentType != Byte.TYPE) break block13;
                    byte[] array = (byte[])value;
                    result = new float[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        result[i] = array[i];
                    }
                    break block9;
                }
                if (primitiveComponentType != Character.TYPE) break block14;
                char[] array = (char[])value;
                result = new float[array.length];
                for (int i = 0; i < array.length; ++i) {
                    result[i] = array[i];
                }
                break block9;
            }
            if (primitiveComponentType != Boolean.TYPE) break block9;
            boolean[] array = (boolean[])value;
            result = new float[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] ? 1.0f : 0.0f;
            }
        }
        return result;
    }
}

