/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;

class BinaryFileBuffer {
    public BufferedReader fbr;
    private String cache;
    private boolean empty;

    public BinaryFileBuffer(BufferedReader r) throws IOException {
        this.fbr = r;
        this.reload();
    }

    public boolean empty() {
        return this.empty;
    }

    private void reload() throws IOException {
        try {
            this.cache = this.fbr.readLine();
            if (this.cache == null) {
                this.empty = true;
                this.cache = null;
            } else {
                this.empty = false;
            }
        }
        catch (EOFException oef) {
            this.empty = true;
            this.cache = null;
        }
    }

    public void close() throws IOException {
        this.fbr.close();
    }

    public String peek() {
        if (this.empty()) {
            return null;
        }
        return this.cache.toString();
    }

    public String pop() throws IOException {
        String answer = this.peek();
        this.reload();
        return answer;
    }
}

