/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import aQute.lib.collections.SortedList;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.libg.command.Command;
import aQute.libg.cryptography.SHA1;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepo
implements Plugin,
RepositoryPlugin,
Refreshable,
RegistryPlugin,
Actionable,
Closeable {
    public static final String TRACE = "trace";
    public static final String LOCATION = "location";
    public static final String READONLY = "readonly";
    public static final String NAME = "name";
    public static final String CMD_PATH = "cmd.path";
    public static final String CMD_SHELL = "cmd.shell";
    public static final String CMD_INIT = "cmd.init";
    public static final String CMD_OPEN = "cmd.open";
    public static final String CMD_AFTER_PUT = "cmd.after.put";
    public static final String CMD_REFRESH = "cmd.refresh";
    public static final String CMD_BEFORE_PUT = "cmd.before.put";
    public static final String CMD_ABORT_PUT = "cmd.abort.put";
    public static final String CMD_CLOSE = "cmd.close";
    public static final String CMD_AFTER_ACTION = "cmd.after.action";
    public static final String CMD_BEFORE_GET = "cmd.before.get";
    static final RepositoryPlugin.PutOptions DEFAULTOPTIONS = new RepositoryPlugin.PutOptions();
    public static final int MAX_MAJOR = 999999999;
    String shell;
    String path;
    String init;
    String open;
    String refresh;
    String beforePut;
    String afterPut;
    String abortPut;
    String beforeGet;
    String close;
    String action;
    File[] EMPTY_FILES = new File[0];
    protected File root;
    Registry registry;
    boolean canWrite = true;
    Pattern REPO_FILE = Pattern.compile("([-a-zA-z0-9_\\.]+)-([0-9\\.]+|latest)\\.(jar|lib)");
    Reporter reporter;
    boolean dirty;
    String name;
    boolean inited;
    boolean trace;
    private static String[] names = new String[]{"bytes", "Kb", "Mb", "Gb"};

    public FileRepo() {
    }

    public FileRepo(String name, File location, boolean canWrite) {
        this.name = name;
        this.root = location;
        this.canWrite = canWrite;
    }

    protected boolean init() throws Exception {
        if (this.inited) {
            return false;
        }
        this.inited = true;
        if (this.reporter == null) {
            ReporterAdapter reporter = this.trace ? new ReporterAdapter(System.out) : new ReporterAdapter();
            reporter.setTrace(this.trace);
            reporter.setExceptions(this.trace);
            this.reporter = reporter;
        }
        if (!this.root.isDirectory()) {
            this.root.mkdirs();
            if (!this.root.isDirectory()) {
                throw new IllegalArgumentException("Location cannot be turned into a directory " + this.root);
            }
            this.exec(this.init, this.root.getAbsolutePath());
        }
        this.open();
        return true;
    }

    @Override
    public void setProperties(Map<String, String> map) {
        String location = map.get(LOCATION);
        if (location == null) {
            throw new IllegalArgumentException("Location must be set on a FileRepo plugin");
        }
        this.root = IO.getFile(IO.home, location);
        String readonly = map.get(READONLY);
        if (readonly != null && Boolean.valueOf(readonly).booleanValue()) {
            this.canWrite = false;
        }
        this.name = map.get(NAME);
        this.path = map.get(CMD_PATH);
        this.shell = map.get(CMD_SHELL);
        this.init = map.get(CMD_INIT);
        this.open = map.get(CMD_OPEN);
        this.refresh = map.get(CMD_REFRESH);
        this.beforePut = map.get(CMD_BEFORE_PUT);
        this.abortPut = map.get(CMD_ABORT_PUT);
        this.afterPut = map.get(CMD_AFTER_PUT);
        this.beforeGet = map.get(CMD_BEFORE_GET);
        this.close = map.get(CMD_CLOSE);
        this.action = map.get(CMD_AFTER_ACTION);
        this.trace = map.get(TRACE) != null && Boolean.parseBoolean(map.get(TRACE));
    }

    @Override
    public boolean canWrite() {
        return this.canWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File putArtifact(File tmpFile, byte[] digest) throws Exception {
        assert (tmpFile != null);
        Jar tmpJar = new Jar(tmpFile);
        try {
            this.dirty = true;
            String bsn = tmpJar.getBsn();
            if (bsn == null) {
                throw new IllegalArgumentException("No bsn set in jar: " + tmpFile);
            }
            String versionString = tmpJar.getVersion();
            if (versionString == null) {
                versionString = "0";
            } else if (!Verifier.isVersion(versionString)) {
                throw new IllegalArgumentException("Incorrect version in : " + tmpFile + " " + versionString);
            }
            Version version = new Version(versionString);
            this.reporter.trace("bsn=%s version=%s", bsn, version);
            File dir = new File(this.root, bsn);
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new IOException("Could not create directory " + dir);
            }
            String fName = bsn + "-" + version.getWithoutQualifier() + ".jar";
            File file = new File(dir, fName);
            this.reporter.trace("updating %s ", file.getAbsolutePath());
            tmpJar.close();
            IO.rename(tmpFile, file);
            this.fireBundleAdded(file);
            this.afterPut(file, bsn, version, Hex.toHexString(digest));
            File latest = new File(dir, bsn + "-latest.jar");
            IO.copy(file, latest);
            this.reporter.trace("updated %s", file.getAbsolutePath());
            File file2 = file;
            return file2;
        }
        finally {
            tmpJar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        if (!this.canWrite) {
            throw new IOException("Repository is read-only");
        }
        assert (stream != null);
        if (options == null) {
            options = DEFAULTOPTIONS;
        }
        this.init();
        File tmpFile = IO.createTempFile(this.root, "put", ".jar");
        try {
            RepositoryPlugin.PutResult putResult;
            DigestInputStream dis = new DigestInputStream(stream, MessageDigest.getInstance("SHA-1"));
            try {
                IO.copy((InputStream)dis, tmpFile);
                byte[] digest = dis.getMessageDigest().digest();
                if (options.digest != null && !Arrays.equals(digest, options.digest)) {
                    throw new IOException("Retrieved artifact digest doesn't match specified digest");
                }
                this.beforePut(tmpFile);
                File file = this.putArtifact(tmpFile, digest);
                file.setReadOnly();
                RepositoryPlugin.PutResult result = new RepositoryPlugin.PutResult();
                result.digest = digest;
                result.artifact = file.toURI();
                putResult = result;
            }
            catch (Throwable throwable) {
                try {
                    dis.close();
                    throw throwable;
                }
                catch (Exception e) {
                    this.abortPut(tmpFile);
                    throw e;
                }
            }
            dis.close();
            return putResult;
        }
        finally {
            IO.delete(tmpFile);
        }
    }

    public void setLocation(String string) {
        this.root = IO.getFile(string);
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public List<String> list(String regex) throws Exception {
        this.init();
        Instruction pattern = null;
        if (regex != null) {
            pattern = new Instruction(regex);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.root == null) {
            if (this.reporter != null) {
                this.reporter.error("FileRepo root directory is not set.", new Object[0]);
            }
        } else {
            File[] list = this.root.listFiles();
            if (list != null) {
                for (File f : list) {
                    String fileName;
                    if (!f.isDirectory() || (fileName = f.getName()).charAt(0) == '.' || pattern != null && !pattern.matches(fileName)) continue;
                    result.add(fileName);
                }
            } else if (this.reporter != null) {
                this.reporter.error("FileRepo root directory (%s) does not exist", this.root);
            }
        }
        return result;
    }

    @Override
    public SortedSet<Version> versions(String bsn) throws Exception {
        this.init();
        boolean haslatest = false;
        File dir = new File(this.root, bsn);
        if (dir.isDirectory()) {
            String[] versions = dir.list();
            ArrayList<Version> list = new ArrayList<Version>();
            for (String v : versions) {
                Matcher m = this.REPO_FILE.matcher(v);
                if (!m.matches()) continue;
                String version = m.group(2);
                if (version.equals("latest")) {
                    haslatest = true;
                    continue;
                }
                list.add(new Version(version));
            }
            if (list.isEmpty() && haslatest) {
                list.add(new Version(999999999, 0, 0));
            }
            return new SortedList<Version>((Collection<Comparable<?>>)list);
        }
        return SortedList.empty();
    }

    public String toString() {
        return String.format("%-40s r/w=%s", this.root.getAbsolutePath(), this.canWrite());
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean refresh() throws Exception {
        this.init();
        this.exec(this.refresh, this.root);
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.toString();
        }
        return this.name;
    }

    @Override
    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        this.init();
        this.beforeGet(bsn, version);
        File file = this.getLocal(bsn, version, properties);
        if (file.exists()) {
            for (RepositoryPlugin.DownloadListener l : listeners) {
                try {
                    l.success(file);
                }
                catch (Exception e) {
                    this.reporter.exception(e, "Download listener for %s", file);
                }
            }
            return file;
        }
        return null;
    }

    @Override
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public String getLocation() {
        return ((Object)this.root).toString();
    }

    @Override
    public Map<String, Runnable> actions(Object ... target) throws Exception {
        if (target == null || target.length == 0) {
            return null;
        }
        try {
            String bsn = (String)target[0];
            Version version = (Version)target[1];
            final File f = this.get(bsn, version, null, new RepositoryPlugin.DownloadListener[0]);
            if (f == null) {
                return null;
            }
            HashMap<String, Runnable> actions = new HashMap<String, Runnable>();
            actions.put("Delete " + bsn + "-" + this.status(bsn, version), new Runnable(){

                public void run() {
                    IO.delete(f);
                    if (f.getParentFile().list().length == 0) {
                        IO.delete(f.getParentFile());
                    }
                    FileRepo.this.afterAction(f, "delete");
                }
            });
            return actions;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void afterAction(File f, String key) {
        this.exec(this.action, this.root, f, key);
    }

    @Override
    public String tooltip(Object ... target) throws Exception {
        if (target == null || target.length == 0) {
            return String.format("%s\n%s", this.getName(), this.root);
        }
        try {
            String bsn = (String)target[0];
            Version version = (Version)target[1];
            Map map = null;
            if (target.length > 2) {
                map = (Map)target[2];
            }
            File f = this.getLocal(bsn, version, map);
            String s = String.format("Path: %s\nSize: %s\nSHA1: %s", f.getAbsolutePath(), this.readable(f.length(), 0), SHA1.digest(f).asHex());
            if (f.getName().endsWith(".lib") && f.isFile()) {
                s = s + "\n" + IO.collect(f);
            }
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String title(Object ... target) throws Exception {
        if (target == null || target.length == 0) {
            return this.getName();
        }
        if (target.length == 1 && target[0] instanceof String) {
            return (String)target[0];
        }
        if (target.length == 2 && target[0] instanceof String && target[1] instanceof Version) {
            return this.status((String)target[0], (Version)target[1]);
        }
        return null;
    }

    protected File getLocal(String bsn, Version version, Map<String, String> properties) {
        File fjar;
        File dir = new File(this.root, bsn);
        if (version.getMajor() == 999999999 && version.getMinor() == 0 && version.getMicro() == 0 && version.getQualifier() == null && (fjar = new File(dir, bsn + "-latest.jar")).isFile()) {
            return fjar.getAbsoluteFile();
        }
        fjar = new File(dir, bsn + "-" + version.getWithoutQualifier() + ".jar");
        if (fjar.isFile()) {
            return fjar.getAbsoluteFile();
        }
        File flib = new File(dir, bsn + "-" + version.getWithoutQualifier() + ".lib");
        if (flib.isFile()) {
            return flib.getAbsoluteFile();
        }
        return fjar.getAbsoluteFile();
    }

    protected String status(String bsn, Version version) {
        File file = this.getLocal(bsn, version, null);
        StringBuilder sb = new StringBuilder(version.toString());
        String del = " [";
        if (file.getName().endsWith(".lib")) {
            sb.append(del).append("L");
            del = "";
        }
        if (!file.getName().endsWith(".jar")) {
            sb.append(del).append("?");
            del = "";
        }
        if (!file.isFile()) {
            sb.append(del).append("X");
            del = "";
        }
        if (file.length() == 0L) {
            sb.append(del).append("0");
            del = "";
        }
        if (del.equals("")) {
            sb.append("]");
        }
        return sb.toString();
    }

    private Object readable(long length, int n) {
        if (length < 0L) {
            return "<invalid>";
        }
        if (length < 1024L || n >= names.length) {
            return length + names[n];
        }
        return this.readable(length / 1024L, n + 1);
    }

    @Override
    public void close() throws IOException {
        if (this.inited) {
            this.exec(this.close, this.root.getAbsolutePath());
        }
    }

    protected void open() {
        this.exec(this.open, this.root.getAbsolutePath());
    }

    protected void beforePut(File tmp) {
        this.exec(this.beforePut, this.root.getAbsolutePath(), tmp.getAbsolutePath());
    }

    protected void afterPut(File file, String bsn, Version version, String sha) {
        this.exec(this.afterPut, this.root.getAbsolutePath(), file.getAbsolutePath(), sha);
    }

    protected void abortPut(File tmpFile) {
        this.exec(this.abortPut, this.root.getAbsolutePath(), tmpFile.getAbsolutePath());
    }

    protected void beforeGet(String bsn, Version version) {
        this.exec(this.beforeGet, this.root.getAbsolutePath(), bsn, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBundleAdded(File file) {
        if (this.registry == null) {
            return;
        }
        List<RepositoryListenerPlugin> listeners = this.registry.getPlugins(RepositoryListenerPlugin.class);
        Jar jar = null;
        for (RepositoryListenerPlugin listener : listeners) {
            try {
                if (jar == null) {
                    jar = new Jar(file);
                }
                listener.bundleAdded(this, jar, file);
            }
            catch (Exception e) {
                if (this.reporter == null) continue;
                this.reporter.warning("Repository listener threw an unexpected exception: %s", e);
            }
            finally {
                if (jar == null) continue;
                jar.close();
            }
        }
    }

    void exec(String line, Object ... args) {
        if (line == null) {
            return;
        }
        try {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i == 0) {
                        line = line.replaceAll("\\$\\{@\\}", args[0].toString().replaceAll("\\\\", "\\\\\\\\"));
                    }
                    line = line.replaceAll("\\$" + i, args[i].toString().replaceAll("\\\\", "\\\\\\\\"));
                }
            }
            line = line.replaceAll("\\s*\\$[0-9]\\s*", "");
            int result = 0;
            StringBuilder stdout = new StringBuilder();
            StringBuilder stderr = new StringBuilder();
            if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                Command cmd = new Command("cmd.exe /C " + line);
                cmd.setCwd(this.getRoot());
                result = cmd.execute(stdout, stderr);
            } else {
                if (this.shell == null) {
                    this.shell = "sh";
                }
                Command cmd = new Command(this.shell);
                cmd.setCwd(this.getRoot());
                if (this.path != null) {
                    cmd.inherit();
                    String oldpath = cmd.var("PATH");
                    this.path = this.path.replaceAll("\\s*,\\s*", File.pathSeparator);
                    this.path = this.path.replaceAll("\\$\\{@\\}", oldpath);
                    cmd.var("PATH", this.path);
                }
                result = cmd.execute(line, (Appendable)stdout, (Appendable)stderr);
            }
            if (result != 0) {
                this.reporter.error("Command %s failed with %s %s %s", line, result, stdout, stderr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reporter.exception(e, e.getMessage(), new Object[0]);
        }
    }

    public void setDir(File repoDir) {
        this.root = repoDir;
    }

    public void delete(String bsn, Version version) throws Exception {
        assert (bsn != null);
        SortedSet<Version> versions = version == null ? this.versions(bsn) : new SortedList<Version>(version);
        for (Version v : versions) {
            File f = this.getLocal(bsn, version, null);
            if (!f.isFile()) {
                this.reporter.error("No artifact found for %s:%s", bsn, version);
                continue;
            }
            IO.delete(f);
        }
        if (this.versions(bsn).isEmpty()) {
            IO.delete(new File(this.root, bsn));
        }
    }
}

