/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.IndexableBinaryStringTools;

public final class ICUCollationKeyFilter
extends TokenFilter {
    private Collator collator = null;
    private RawCollationKey reusableKey = new RawCollationKey();
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public ICUCollationKeyFilter(TokenStream input, Collator collator) {
        super(input);
        try {
            this.collator = (Collator)collator.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.buffer();
            String termText = new String(termBuffer, 0, this.termAtt.length());
            this.collator.getRawCollationKey(termText, this.reusableKey);
            int encodedLength = IndexableBinaryStringTools.getEncodedLength((byte[])this.reusableKey.bytes, (int)0, (int)this.reusableKey.size);
            if (encodedLength > termBuffer.length) {
                this.termAtt.resizeBuffer(encodedLength);
            }
            this.termAtt.setLength(encodedLength);
            IndexableBinaryStringTools.encode((byte[])this.reusableKey.bytes, (int)0, (int)this.reusableKey.size, (char[])this.termAtt.buffer(), (int)0, (int)encodedLength);
            return true;
        }
        return false;
    }
}

