/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.collect.Iterables;
import java.util.Collections;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.index.SecondaryIndex;

final class TermSlice {
    private final Term[] bounds;
    private final boolean[] boundInclusive;

    private TermSlice(Term start, boolean includeStart, Term end, boolean includeEnd) {
        this.bounds = new Term[]{start, end};
        this.boundInclusive = new boolean[]{includeStart, includeEnd};
    }

    public static TermSlice newInstance(Bound bound, boolean include, Term term) {
        return bound.isStart() ? new TermSlice(term, include, null, false) : new TermSlice(null, false, term, include);
    }

    public Term bound(Bound bound) {
        return this.bounds[bound.idx];
    }

    public boolean hasBound(Bound b) {
        return this.bounds[b.idx] != null;
    }

    public boolean isInclusive(Bound b) {
        return this.bounds[b.idx] == null || this.boundInclusive[b.idx];
    }

    public TermSlice merge(TermSlice otherSlice) {
        if (this.hasBound(Bound.START)) {
            assert (!otherSlice.hasBound(Bound.START));
            return new TermSlice(this.bound(Bound.START), this.isInclusive(Bound.START), otherSlice.bound(Bound.END), otherSlice.isInclusive(Bound.END));
        }
        assert (!otherSlice.hasBound(Bound.END));
        return new TermSlice(otherSlice.bound(Bound.START), otherSlice.isInclusive(Bound.START), this.bound(Bound.END), this.isInclusive(Bound.END));
    }

    public String toString() {
        return String.format("(%s %s, %s %s)", this.boundInclusive[0] ? ">=" : ">", this.bounds[0], this.boundInclusive[1] ? "<=" : "<", this.bounds[1]);
    }

    public Operator getIndexOperator(Bound b) {
        if (b.isStart()) {
            return this.boundInclusive[b.idx] ? Operator.GTE : Operator.GT;
        }
        return this.boundInclusive[b.idx] ? Operator.LTE : Operator.LT;
    }

    public boolean isSupportedBy(SecondaryIndex index) {
        boolean supported = false;
        if (this.hasBound(Bound.START)) {
            supported |= this.isInclusive(Bound.START) ? index.supportsOperator(Operator.GTE) : index.supportsOperator(Operator.GT);
        }
        if (this.hasBound(Bound.END)) {
            supported |= this.isInclusive(Bound.END) ? index.supportsOperator(Operator.LTE) : index.supportsOperator(Operator.LT);
        }
        return supported;
    }

    public Iterable<Function> getFunctions() {
        if (this.hasBound(Bound.START) && this.hasBound(Bound.END)) {
            return Iterables.concat(this.bound(Bound.START).getFunctions(), this.bound(Bound.END).getFunctions());
        }
        if (this.hasBound(Bound.START)) {
            return this.bound(Bound.START).getFunctions();
        }
        if (this.hasBound(Bound.END)) {
            return this.bound(Bound.END).getFunctions();
        }
        return Collections.emptySet();
    }
}

